/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.Expression;
import io.ebean.event.BeanQueryRequest;
import io.ebeaninternal.api.ManyWhereJoins;
import io.ebeaninternal.api.NaturalKeyQueryData;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.api.SpiExpressionValidation;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.expression.DocQueryContext;
import java.io.IOException;

final class NotExpression
implements SpiExpression {
    private static final String NOT_START = "not (";
    private static final String NOT_END = ")";
    private final SpiExpression exp;

    NotExpression(Expression exp) {
        this.exp = (SpiExpression)exp;
    }

    @Override
    public void prefixProperty(String path) {
        this.exp.prefixProperty(path);
    }

    @Override
    public boolean naturalKey(NaturalKeyQueryData<?> data) {
        return false;
    }

    @Override
    public void simplify() {
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.startBoolMustNot();
        this.exp.writeDocQuery(context);
        context.endBool();
    }

    @Override
    public Object getIdEqualTo(String idName) {
        return null;
    }

    @Override
    public SpiExpression copyForPlanKey() {
        return new NotExpression(this.exp.copyForPlanKey());
    }

    @Override
    public String nestedPath(BeanDescriptor<?> desc) {
        return this.exp.nestedPath(desc);
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
        this.exp.containsMany(desc, manyWhereJoin);
    }

    @Override
    public void validate(SpiExpressionValidation validation) {
        this.exp.validate(validation);
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        this.exp.addBindValues(request);
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        request.append(NOT_START);
        this.exp.addSql(request);
        request.append(NOT_END);
    }

    @Override
    public void prepareExpression(BeanQueryRequest<?> request) {
        this.exp.prepareExpression(request);
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append("Not[");
        this.exp.queryPlanHash(builder);
        builder.append("]");
    }

    @Override
    public int queryBindHash() {
        return this.exp.queryBindHash();
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        NotExpression that = (NotExpression)other;
        return this.exp.isSameByBind(that.exp);
    }
}

