/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.meta.MetricVisitor;
import io.ebean.metric.MetricFactory;
import io.ebean.metric.TimedMetric;
import io.ebeaninternal.server.core.PersistRequest;

class BeanIudMetrics {
    private final TimedMetric insert;
    private final TimedMetric update;
    private final TimedMetric delete;
    private final TimedMetric insertBatch;
    private final TimedMetric updateBatch;
    private final TimedMetric deleteBatch;

    BeanIudMetrics(String beanShortName) {
        MetricFactory metricFactory = MetricFactory.get();
        String prefix = "iud." + beanShortName;
        this.insert = metricFactory.createTimedMetric(prefix + ".insert");
        this.update = metricFactory.createTimedMetric(prefix + ".update");
        this.delete = metricFactory.createTimedMetric(prefix + ".delete");
        this.insertBatch = metricFactory.createTimedMetric(prefix + ".insertBatch");
        this.updateBatch = metricFactory.createTimedMetric(prefix + ".updateBatch");
        this.deleteBatch = metricFactory.createTimedMetric(prefix + ".deleteBatch");
    }

    void addBatch(PersistRequest.Type type, long startNanos, int batch) {
        switch (type) {
            case INSERT: {
                this.insertBatch.addBatchSince(startNanos, batch);
                break;
            }
            case UPDATE: 
            case DELETE_SOFT: {
                this.updateBatch.addBatchSince(startNanos, batch);
                break;
            }
            case DELETE: 
            case DELETE_PERMANENT: {
                this.deleteBatch.addBatchSince(startNanos, batch);
            }
        }
    }

    void addNoBatch(PersistRequest.Type type, long startNanos) {
        switch (type) {
            case INSERT: {
                this.insert.addSinceNanos(startNanos);
                break;
            }
            case UPDATE: 
            case DELETE_SOFT: {
                this.update.addSinceNanos(startNanos);
                break;
            }
            case DELETE: 
            case DELETE_PERMANENT: {
                this.delete.addSinceNanos(startNanos);
            }
        }
    }

    void visit(MetricVisitor visitor) {
        this.insert.visit(visitor);
        this.update.visit(visitor);
        this.delete.visit(visitor);
        this.insertBatch.visit(visitor);
        this.updateBatch.visit(visitor);
        this.deleteBatch.visit(visitor);
    }
}

