/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.meta.MetaCountMetric;
import io.ebean.meta.MetaQueryMetric;
import io.ebean.meta.MetaTimedMetric;
import io.ebean.meta.ServerMetrics;
import io.ebean.meta.SortMetric;
import io.ebeaninternal.api.SpiEbeanServer;
import java.util.Comparator;
import java.util.List;

class DumpMetrics {
    private final SpiEbeanServer server;
    private final String options;
    private final String nameFormat;
    private final String nameFormatTimed;
    private boolean dumpHash;
    private boolean dumpSql;
    private boolean dumpLoc;
    private Comparator<MetaTimedMetric> sortBy = SortMetric.NAME;

    DumpMetrics(SpiEbeanServer server, String options) {
        this.server = server;
        this.options = options;
        int width = 0;
        if (options != null) {
            this.dumpLoc = options.contains("loc");
            this.dumpSql = options.contains("sql");
            this.dumpHash = options.contains("hash");
            for (int i = 5; i < 10; ++i) {
                width = Math.max(width, this.optionWidth(i * 10));
            }
            for (String option : new String[]{"Total", "Count", "Mean", "Max"}) {
                this.sortOption(option);
            }
        }
        if (width == 0) {
            width = 80;
        }
        this.nameFormat = "%1$-" + width + "s";
        this.nameFormatTimed = "%1$-" + (width + 6) + "s";
    }

    private int optionWidth(int check) {
        return this.options.contains("w" + check) ? check : 0;
    }

    private void sortOption(String option) {
        if (this.options.contains("sort" + option)) {
            this.sortBy = this.setSortOption(option);
        }
    }

    private Comparator<MetaTimedMetric> setSortOption(String option) {
        switch (option.toUpperCase()) {
            case "TOTAL": {
                return SortMetric.TOTAL;
            }
            case "COUNT": {
                return SortMetric.COUNT;
            }
            case "MEAN": {
                return SortMetric.MEAN;
            }
            case "MAX": {
                return SortMetric.MAX;
            }
        }
        return SortMetric.NAME;
    }

    void dump() {
        List queryMetrics;
        this.out("-- Dumping metrics for " + this.server.getName() + " -- ");
        ServerMetrics serverMetrics = this.server.getMetaInfoManager().collectMetrics();
        for (Object metric : serverMetrics.timedMetrics()) {
            this.log((MetaTimedMetric)metric);
        }
        List countMetrics = serverMetrics.countMetrics();
        if (!countMetrics.isEmpty()) {
            this.out("\n-- Counters --");
            countMetrics.sort(SortMetric.COUNT_NAME);
            for (MetaCountMetric metric : countMetrics) {
                this.logCount(metric);
            }
        }
        if (!(queryMetrics = serverMetrics.queryMetrics()).isEmpty()) {
            this.out("\n-- Queries --");
            queryMetrics.sort(this.sortBy);
            for (MetaQueryMetric metric : queryMetrics) {
                this.logQuery(metric);
            }
        }
    }

    private void logCount(MetaCountMetric metric) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.padNameTimed(metric.name())).append(" ");
        sb.append(" count:").append(this.pad(metric.count()));
        this.out(sb.toString());
    }

    private void out(String sb) {
        System.out.println(sb);
    }

    private void logQuery(MetaQueryMetric metric) {
        StringBuilder sb = new StringBuilder();
        this.appendQueryName(metric, sb);
        this.appendCounters((MetaTimedMetric)metric, sb);
        if (this.dumpHash) {
            sb.append("\n sqlHash:").append(metric.sqlHash());
        }
        this.appendProfileAndSql(metric, sb);
        this.out(sb.toString());
    }

    private void appendQueryName(MetaQueryMetric metric, StringBuilder sb) {
        sb.append("query:").append(this.padName(metric.name())).append(" ");
    }

    private void appendProfileAndSql(MetaQueryMetric metric, StringBuilder sb) {
        String location = metric.location();
        if (this.dumpLoc && location != null) {
            sb.append("\n  loc:").append(location);
            sb.append("\n  locHash:").append(metric.locationHash());
        }
        if (this.dumpSql) {
            sb.append(" \n\n  sql:").append(metric.sql()).append("\n\n");
        }
    }

    private void log(MetaTimedMetric metric) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.padNameTimed(metric.name())).append(" ");
        this.appendCounters(metric, sb);
        this.out(sb.toString());
    }

    private void appendCounters(MetaTimedMetric timedMetric, StringBuilder sb) {
        sb.append(" count:").append(this.pad(timedMetric.count())).append(" total:").append(this.pad(timedMetric.total())).append(" mean:").append(this.pad(timedMetric.mean())).append(" max:").append(this.pad(timedMetric.max()));
    }

    private String padName(String name) {
        return String.format(this.nameFormat, name);
    }

    private String padNameTimed(String name) {
        return String.format(this.nameFormatTimed, name);
    }

    private String pad(long value) {
        return String.format("%1$-8s", value);
    }
}

