/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.api;

import io.ebeaninternal.server.persist.MultiValueWrapper;
import io.ebeaninternal.server.querydefn.NaturalKeyBindParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BindParams
implements Serializable {
    private static final long serialVersionUID = 4541081933302086285L;
    private final List<Param> positionedParameters = new ArrayList<Param>();
    private final Map<String, Param> namedParameters = new LinkedHashMap<String, Param>();
    private String preparedSql;
    private String bindHash;
    private int addPos;

    public void reset() {
        this.bindHash = null;
        this.positionedParameters.clear();
    }

    public int queryBindHash() {
        int hc = this.namedParameters.hashCode();
        for (Param positionedParameter : this.positionedParameters) {
            hc = hc * 92821 + positionedParameter.hashCode();
        }
        return hc;
    }

    public String calcQueryPlanHash() {
        StringBuilder builder = new StringBuilder();
        this.buildQueryPlanHash(builder);
        return builder.toString();
    }

    public void buildQueryPlanHash(StringBuilder builder) {
        int tempBindCount;
        int bc = 0;
        for (Param param : this.positionedParameters) {
            tempBindCount = param.queryBindCount();
            builder.append("p").append(bc += tempBindCount).append(" ?:").append(tempBindCount).append(",");
        }
        for (Map.Entry entry : this.namedParameters.entrySet()) {
            tempBindCount = ((Param)entry.getValue()).queryBindCount();
            builder.append("n").append(bc += tempBindCount).append(" k:").append((String)entry.getKey()).append(" ?:").append(tempBindCount).append(",");
        }
    }

    public BindParams copy() {
        BindParams copy = new BindParams();
        for (Param param : this.positionedParameters) {
            copy.positionedParameters.add(param.copy());
        }
        for (Map.Entry entry : this.namedParameters.entrySet()) {
            copy.namedParameters.put((String)entry.getKey(), ((Param)entry.getValue()).copy());
        }
        return copy;
    }

    public boolean isEmpty() {
        return this.positionedParameters.isEmpty() && this.namedParameters.isEmpty();
    }

    public NaturalKeyBindParam getNaturalKeyBindParam() {
        if (!this.positionedParameters.isEmpty()) {
            return null;
        }
        if (this.namedParameters.size() == 1) {
            Map.Entry<String, Param> e = this.namedParameters.entrySet().iterator().next();
            return new NaturalKeyBindParam(e.getKey(), e.getValue().getInValue());
        }
        return null;
    }

    public int size() {
        return this.positionedParameters.size();
    }

    public boolean requiresNamedParamsPrepare() {
        return !this.namedParameters.isEmpty();
    }

    public void setNullParameter(int position, int jdbcType) {
        Param p = this.getParam(position);
        p.setInNullType(jdbcType);
    }

    public void setParameter(int position, Object value, int outType) {
        Param p = this.getParam(position);
        p.setInValue(value);
        p.setOutType(outType);
    }

    public void setNextParameters(Object ... values) {
        for (Object value : values) {
            this.setNextParameter(value);
        }
    }

    public void setNextParameter(Object value) {
        this.setParameter(++this.addPos, value);
    }

    public void setParameter(int position, Object value) {
        Param p = this.getParam(position);
        if (value instanceof Collection) {
            value = new MultiValueWrapper((Collection)value);
        }
        p.setInValue(value);
    }

    public void registerOut(int position, int outType) {
        Param p = this.getParam(position);
        p.setOutType(outType);
    }

    private Param getParam(String name) {
        return this.namedParameters.computeIfAbsent(name, k -> new Param());
    }

    private Param getParam(int position) {
        int more = position - this.positionedParameters.size();
        if (more > 0) {
            for (int i = 0; i < more; ++i) {
                this.positionedParameters.add(new Param());
            }
        }
        return this.positionedParameters.get(position - 1);
    }

    public void setParameter(String name, Object value, int outType) {
        Param p = this.getParam(name);
        p.setInValue(value);
        p.setOutType(outType);
    }

    public void setNullParameter(String name, int jdbcType) {
        Param p = this.getParam(name);
        p.setInNullType(jdbcType);
    }

    public Param setParameter(String name, Object value) {
        Param p = this.getParam(name);
        p.setInValue(value);
        return p;
    }

    public Param setEncryptionKey(String name, Object value) {
        Param p = this.getParam(name);
        p.setEncryptionKey(value);
        return p;
    }

    public void registerOut(String name, int outType) {
        Param p = this.getParam(name);
        p.setOutType(outType);
    }

    public Param getParameter(int position) {
        return this.getParam(position);
    }

    public Param getParameter(String name) {
        return this.getParam(name);
    }

    public List<Param> positionedParameters() {
        return this.positionedParameters;
    }

    public void setPreparedSql(String preparedSql) {
        this.preparedSql = preparedSql;
    }

    public String getPreparedSql() {
        return this.preparedSql;
    }

    public boolean isSameBindHash() {
        if (this.bindHash == null) {
            this.bindHash = this.calcQueryPlanHash();
            return false;
        }
        String oldPlan = this.bindHash;
        this.bindHash = this.calcQueryPlanHash();
        return this.bindHash.equals(oldPlan);
    }

    public OrderedList createOrderedList() {
        this.positionedParameters.clear();
        return new OrderedList(this.positionedParameters);
    }

    public static final class Param
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private boolean encryptionKey;
        private boolean isInParam;
        private boolean isOutParam;
        private int type;
        private Object inValue;
        private Object outValue;

        public int queryBindCount() {
            if (this.inValue == null) {
                return 0;
            }
            if (this.inValue instanceof Collection) {
                return ((Collection)this.inValue).size();
            }
            return 1;
        }

        public Param copy() {
            Param copy = new Param();
            copy.isInParam = this.isInParam;
            copy.isOutParam = this.isOutParam;
            copy.type = this.type;
            copy.inValue = this.inValue;
            copy.outValue = this.outValue;
            return copy;
        }

        public int hashCode() {
            int hc = this.getClass().hashCode();
            hc = hc * 92821 + (this.isInParam ? 0 : 1);
            hc = hc * 92821 + (this.isOutParam ? 0 : 1);
            hc = hc * 92821 + this.type;
            hc = hc * 92821 + (this.inValue == null ? 0 : this.inValue.hashCode());
            return hc;
        }

        public boolean equals(Object o) {
            return o != null && (o == this || o instanceof Param && this.hashCode() == o.hashCode());
        }

        public boolean isInParam() {
            return this.isInParam;
        }

        public boolean isOutParam() {
            return this.isOutParam;
        }

        public int getType() {
            return this.type;
        }

        public void setOutType(int type) {
            this.type = type;
            this.isOutParam = true;
        }

        public void setInValue(Object in) {
            this.inValue = in;
            this.isInParam = true;
        }

        public void setEncryptionKey(Object in) {
            this.inValue = in;
            this.isInParam = true;
            this.encryptionKey = true;
        }

        public void setInNullType(int type) {
            this.type = type;
            this.inValue = null;
            this.isInParam = true;
        }

        public Object getOutValue() {
            return this.outValue;
        }

        public Object getInValue() {
            return this.inValue;
        }

        public void setOutValue(Object out) {
            this.outValue = out;
        }

        public boolean isEncryptionKey() {
            return this.encryptionKey;
        }
    }

    public static final class OrderedList {
        private final List<Param> paramList;
        private final StringBuilder preparedSql;

        public OrderedList(List<Param> paramList) {
            this.paramList = paramList;
            this.preparedSql = new StringBuilder();
        }

        public void add(Param param) {
            this.paramList.add(param);
        }

        public int size() {
            return this.paramList.size();
        }

        public List<Param> list() {
            return this.paramList;
        }

        public void appendSql(String parsedSql) {
            this.preparedSql.append(parsedSql);
        }

        public String getPreparedSql() {
            return this.preparedSql.toString();
        }
    }
}

