/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.autotune.service;

import io.ebeaninternal.server.autotune.service.AutoTuneCollection;
import java.io.Serializable;
import java.util.concurrent.atomic.LongAdder;

public class ProfileOriginQuery
implements Serializable {
    private static final long serialVersionUID = -1133958958072778811L;
    private final String path;
    private final LongAdder exeCount = new LongAdder();
    private final LongAdder totalBeanLoaded = new LongAdder();
    private final LongAdder totalMicros = new LongAdder();

    public ProfileOriginQuery(String path) {
        this.path = path;
    }

    public void add(long beansLoaded, long micros) {
        this.exeCount.increment();
        this.totalBeanLoaded.add(beansLoaded);
        this.totalMicros.add(micros);
    }

    public AutoTuneCollection.EntryQuery createEntryQuery(boolean reset) {
        if (reset) {
            return new AutoTuneCollection.EntryQuery(this.path, this.exeCount.sumThenReset(), this.totalBeanLoaded.sumThenReset(), this.totalMicros.sumThenReset());
        }
        return new AutoTuneCollection.EntryQuery(this.path, this.exeCount.sum(), this.totalBeanLoaded.sum(), this.totalMicros.sum());
    }
}

