/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.autotune.service;

import io.ebean.bean.NodeUsageCollector;
import io.ebean.text.PathProperties;
import io.ebean.util.SplitName;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssoc;
import io.ebeaninternal.server.el.ElPropertyValue;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileOriginNodeUsage {
    private static final Logger logger = LoggerFactory.getLogger(ProfileOriginNodeUsage.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final String path;
    private int profileCount;
    private int profileUsedCount;
    private boolean modified;
    private final Set<String> aggregateUsed = new LinkedHashSet<String>();

    public ProfileOriginNodeUsage(String path) {
        this.path = "".equals(path) ? null : path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildTunedFetch(PathProperties pathProps, BeanDescriptor<?> rootDesc, boolean addVersionProperty) {
        this.lock.lock();
        try {
            BeanProperty versionProp;
            BeanDescriptor desc = rootDesc;
            if (this.path != null) {
                ElPropertyValue elGetValue = rootDesc.getElGetValue(this.path);
                if (elGetValue == null) {
                    logger.warn("AutoTune: Can't find join for path[" + this.path + "] for " + rootDesc.getName());
                    return;
                }
                BeanProperty beanProperty = elGetValue.getBeanProperty();
                if (beanProperty instanceof BeanPropertyAssoc) {
                    desc = ((BeanPropertyAssoc)beanProperty).getTargetDescriptor();
                }
            }
            BeanProperty toOneIdProperty = null;
            boolean addedToPath = false;
            for (String propName : this.aggregateUsed) {
                BeanProperty beanProp = desc.findPropertyFromPath(propName);
                if (beanProp == null) {
                    logger.warn("AutoTune: Can't find property[" + propName + "] for " + desc.getName());
                    continue;
                }
                if (beanProp.isId()) {
                    toOneIdProperty = beanProp;
                    continue;
                }
                if (beanProp instanceof BeanPropertyAssoc || beanProp.isLob() && !beanProp.isFetchEager()) continue;
                addedToPath = true;
                pathProps.addToPath(this.path, beanProp.getName());
            }
            if ((this.modified || addVersionProperty) && desc != null && (versionProp = desc.getVersionProperty()) != null) {
                addedToPath = true;
                pathProps.addToPath(this.path, versionProp.getName());
            }
            if (toOneIdProperty != null && !addedToPath) {
                ElPropertyValue assocOne = rootDesc.getElGetValue(this.path);
                pathProps.addToPath(SplitName.parent((String)this.path), assocOne.getName());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void collectUsageInfo(NodeUsageCollector profile) {
        this.lock.lock();
        try {
            Set used = profile.getUsed();
            ++this.profileCount;
            if (!used.isEmpty()) {
                ++this.profileUsedCount;
                this.aggregateUsed.addAll(used);
            }
            if (profile.isModified()) {
                this.modified = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "path[" + this.path + "] profileCount[" + this.profileCount + "] used[" + this.profileUsedCount + "] props" + this.aggregateUsed;
    }
}

