/*
 * Decompiled with CFR 0.152.
 */
package io.ebean;

import java.io.Serializable;

public final class FetchConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int JOIN_MODE = 0;
    private static final int QUERY_MODE = 1;
    private static final int LAZY_MODE = 2;
    private static final int CACHE_MODE = 3;
    private final int mode;
    private final int batchSize;
    private final int hashCode;

    private FetchConfig(int mode, int batchSize) {
        this.mode = mode;
        this.batchSize = batchSize;
        this.hashCode = mode + 10 * batchSize;
    }

    public static FetchConfig ofCache() {
        return new FetchConfig(3, 100);
    }

    public static FetchConfig ofQuery() {
        return new FetchConfig(1, 100);
    }

    public static FetchConfig ofQuery(int batchSize) {
        return new FetchConfig(1, batchSize);
    }

    public static FetchConfig ofLazy() {
        return new FetchConfig(2, 0);
    }

    public static FetchConfig ofLazy(int batchSize) {
        return new FetchConfig(2, batchSize);
    }

    public static FetchConfig ofDefault() {
        return new FetchConfig(0, 100);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean isCache() {
        return this.mode == 3;
    }

    public boolean isQuery() {
        return this.mode == 1;
    }

    public boolean isLazy() {
        return this.mode == 2;
    }

    public boolean isJoin() {
        return this.mode == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.hashCode == ((FetchConfig)o).hashCode;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

