/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.meta;

import io.ebean.meta.MetaCountMetric;
import io.ebean.meta.MetaMetric;
import io.ebean.meta.MetaQueryMetric;
import io.ebean.meta.MetaTimedMetric;
import io.ebean.meta.MetricData;
import io.ebean.meta.ServerMetrics;
import java.util.ArrayList;
import java.util.List;

final class MetricsAsData {
    private final ServerMetrics metrics;
    private final List<MetricData> list = new ArrayList<MetricData>();

    MetricsAsData(ServerMetrics metrics) {
        this.metrics = metrics;
    }

    List<MetricData> data() {
        for (MetaTimedMetric metaTimedMetric : this.metrics.timedMetrics()) {
            this.add(metaTimedMetric);
        }
        for (MetaCountMetric metaCountMetric : this.metrics.countMetrics()) {
            this.addCount(metaCountMetric);
        }
        for (MetaQueryMetric metaQueryMetric : this.metrics.queryMetrics()) {
            this.addQuery(metaQueryMetric);
        }
        return this.list;
    }

    private MetricData create(MetaMetric metric) {
        MetricData data = new MetricData(metric.name());
        this.list.add(data);
        return data;
    }

    private void add(MetaTimedMetric metric) {
        MetricData data = this.create(metric);
        this.appendCounters(data, metric);
        data.setLoc(metric.location());
    }

    private void addCount(MetaCountMetric metric) {
        MetricData data = this.create(metric);
        data.setCount(metric.count());
    }

    private void addQuery(MetaQueryMetric metric) {
        MetricData data = this.create(metric);
        this.appendCounters(data, metric);
        this.appendLocationAndSql(data, metric);
        data.setHash(metric.hash());
    }

    private void appendLocationAndSql(MetricData data, MetaQueryMetric metric) {
        data.setLoc(metric.location());
        data.setSql(metric.sql());
    }

    private void appendCounters(MetricData data, MetaTimedMetric timedMetric) {
        data.setCount(timedMetric.count());
        data.setTotal(timedMetric.total());
        data.setMean(timedMetric.mean());
        data.setMax(timedMetric.max());
    }
}

