/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.common;

import io.ebean.common.BeanMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class ModifyEntrySet<K, E>
implements Set<Map.Entry<K, E>> {
    private final BeanMap<K, E> owner;
    private final Set<Map.Entry<K, E>> entrySet;

    ModifyEntrySet(BeanMap<K, E> owner, Set<Map.Entry<K, E>> entrySet) {
        this.owner = owner;
        this.entrySet = entrySet;
    }

    @Override
    public int size() {
        return this.entrySet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.entrySet.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.entrySet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.entrySet.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> entries) {
        return this.entrySet.containsAll(entries);
    }

    @Override
    public void clear() {
        this.owner.clear();
    }

    @Override
    public boolean add(Map.Entry<K, E> entry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Map.Entry<K, E>> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        Map.Entry entry;
        E val;
        if (o instanceof Map.Entry && Objects.equals(val = this.owner.get((entry = (Map.Entry)o).getKey()), entry.getValue())) {
            this.owner.remove(entry.getKey());
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> entries) {
        boolean modified = false;
        Iterator<Map.Entry<K, E>> it = this.iterator();
        while (it.hasNext()) {
            if (entries.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> entries) {
        boolean modified = false;
        for (Object entry : entries) {
            modified |= this.remove(entry);
        }
        return modified;
    }

    @Override
    public Iterator<Map.Entry<K, E>> iterator() {
        return new EntrySetIterator(new ArrayList<Map.Entry<K, E>>(this.entrySet).iterator());
    }

    class EntrySetIterator
    implements Iterator<Map.Entry<K, E>> {
        private final Iterator<Map.Entry<K, E>> iterator;
        private Map.Entry<K, E> entry;

        EntrySetIterator(Iterator<Map.Entry<K, E>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, E> next() {
            this.entry = this.iterator.next();
            return this.entry;
        }

        @Override
        public void remove() {
            ModifyEntrySet.this.owner.remove(this.entry.getKey());
            this.iterator.remove();
        }
    }
}

