/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config.dbplatform.db2;

import io.ebean.BackgroundExecutor;
import io.ebean.annotation.PersistBatch;
import io.ebean.annotation.Platform;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.DbPlatformType;
import io.ebean.config.dbplatform.DbType;
import io.ebean.config.dbplatform.PlatformIdGenerator;
import io.ebean.config.dbplatform.SqlErrorCodes;
import io.ebean.config.dbplatform.db2.DB2SequenceIdGenerator;
import io.ebean.config.dbplatform.db2.Db2SqlLimiter;
import javax.sql.DataSource;

public class DB2Platform
extends DatabasePlatform {
    public DB2Platform() {
        this.platform = Platform.DB2;
        this.maxTableNameLength = 18;
        this.maxConstraintNameLength = 18;
        this.truncateTable = "truncate table %s reuse storage ignore delete triggers immediate";
        this.sqlLimiter = new Db2SqlLimiter();
        this.dbIdentity.setSupportsGetGeneratedKeys(true);
        this.dbIdentity.setSupportsSequence(true);
        this.exceptionTranslator = new SqlErrorCodes().addAcquireLock("40001", "57033").addDuplicateKey("23505").addDataIntegrity("23502", "23503", "23504", "23511", "23512", "23511", "42917", "23515").build();
        this.booleanDbType = 16;
        this.dbTypeMap.put(DbType.TINYINT, new DbPlatformType("smallint", false));
        this.dbTypeMap.put(DbType.INTEGER, new DbPlatformType("integer", false));
        this.dbTypeMap.put(DbType.BIGINT, new DbPlatformType("bigint", false));
        this.dbTypeMap.put(DbType.REAL, new DbPlatformType("real"));
        this.dbTypeMap.put(DbType.DECIMAL, new DbPlatformType("decimal", 16, 3));
        this.persistBatchOnCascade = PersistBatch.NONE;
    }

    @Override
    public PlatformIdGenerator createSequenceIdGenerator(BackgroundExecutor be, DataSource ds, int stepSize, String seqName) {
        return new DB2SequenceIdGenerator(be, ds, seqName, this.sequenceBatchSize);
    }
}

