/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config.dbplatform;

import io.ebean.BackgroundExecutor;
import io.ebean.Query;
import io.ebean.annotation.PartitionMode;
import io.ebean.annotation.PersistBatch;
import io.ebean.annotation.Platform;
import io.ebean.config.CustomDbTypeMapping;
import io.ebean.config.PlatformConfig;
import io.ebean.config.dbplatform.BasicSqlLimitOffset;
import io.ebean.config.dbplatform.BasicSqlLimiter;
import io.ebean.config.dbplatform.DbDefaultValue;
import io.ebean.config.dbplatform.DbEncrypt;
import io.ebean.config.dbplatform.DbHistorySupport;
import io.ebean.config.dbplatform.DbIdentity;
import io.ebean.config.dbplatform.DbPlatformType;
import io.ebean.config.dbplatform.DbPlatformTypeMapping;
import io.ebean.config.dbplatform.IdType;
import io.ebean.config.dbplatform.LimitOffsetSqlLimiter;
import io.ebean.config.dbplatform.PlatformIdGenerator;
import io.ebean.config.dbplatform.SqlCodeTranslator;
import io.ebean.config.dbplatform.SqlExceptionTranslator;
import io.ebean.config.dbplatform.SqlLimiter;
import io.ebean.util.JdbcClose;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabasePlatform {
    private static final Logger logger = LoggerFactory.getLogger(DatabasePlatform.class);
    protected boolean useExtraTransactionOnIterateSecondaryQueries;
    protected boolean supportsDeleteTableAlias;
    protected boolean supportsSavepointId = true;
    protected OnQueryOnly onQueryOnly = OnQueryOnly.COMMIT;
    protected String openQuote = "\"";
    protected String closeQuote = "\"";
    protected boolean allQuotedIdentifiers;
    protected boolean caseSensitiveCollation = true;
    protected boolean inlineSqlUpdateLimit;
    protected SqlLimiter sqlLimiter = new LimitOffsetSqlLimiter();
    protected BasicSqlLimiter basicSqlLimiter = new BasicSqlLimitOffset();
    protected DbPlatformTypeMapping dbTypeMap = new DbPlatformTypeMapping();
    protected DbDefaultValue dbDefaultValue = new DbDefaultValue();
    protected boolean nativeUuidType;
    protected DbIdentity dbIdentity = new DbIdentity();
    protected boolean sequenceBatchMode = true;
    protected int sequenceBatchSize = 20;
    protected DbHistorySupport historySupport;
    protected int booleanDbType = 16;
    protected int blobDbType = 2004;
    protected int clobDbType = 2005;
    protected boolean treatEmptyStringsAsNull;
    protected Platform platform = Platform.GENERIC;
    protected String truncateTable = "truncate table %s";
    protected String columnAliasPrefix;
    private static final char BACK_TICK = '`';
    protected String likeClauseRaw = "like ? escape''";
    protected String likeClauseEscaped = "like ? escape'|'";
    protected char likeEscapeChar = (char)124;
    protected char[] likeSpecialCharacters = new char[]{'%', '_', '|'};
    protected DbEncrypt dbEncrypt;
    protected boolean idInExpandedForm;
    protected boolean selectCountWithAlias;
    protected boolean selectCountWithColumnAlias;
    protected boolean forwardOnlyHintOnFindIterate;
    protected boolean supportsResultSetConcurrencyModeUpdatable = true;
    protected PersistBatch persistBatchOnCascade = PersistBatch.ALL;
    protected int maxTableNameLength = 60;
    protected int maxConstraintNameLength = 60;
    protected boolean supportsNativeIlike;
    protected SqlExceptionTranslator exceptionTranslator = new SqlCodeTranslator();

    public PersistenceException translate(String message, SQLException e) {
        return this.exceptionTranslator.translate(message, e);
    }

    public void configure(PlatformConfig config) {
        this.sequenceBatchSize = config.getDatabaseSequenceBatchSize();
        this.caseSensitiveCollation = config.isCaseSensitiveCollation();
        this.configureIdType(config.getIdType());
        this.configure(config, config.isAllQuotedIdentifiers());
    }

    protected void configure(PlatformConfig config, boolean allQuotedIdentifiers) {
        this.allQuotedIdentifiers = allQuotedIdentifiers;
        this.addGeoTypes(config.getGeometrySRID());
        this.configureIdType(config.getIdType());
        this.dbTypeMap.config(this.nativeUuidType, config.getDbUuid());
        for (CustomDbTypeMapping mapping : config.getCustomTypeMappings()) {
            if (!this.platformMatch(mapping.getPlatform())) continue;
            this.dbTypeMap.put(mapping.getType(), this.parse(mapping.getColumnDefinition()));
        }
    }

    protected void configureIdType(IdType idType) {
        if (idType != null) {
            this.dbIdentity.setIdType(idType);
        }
    }

    protected void addGeoTypes(int srid) {
    }

    private DbPlatformType parse(String columnDefinition) {
        return DbPlatformType.parse(columnDefinition);
    }

    private boolean platformMatch(Platform platform) {
        return platform == null || this.isPlatform(platform);
    }

    public boolean isPlatform(Platform platform) {
        return this.platform.base() == platform;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public String getName() {
        return this.platform.name().toLowerCase();
    }

    public boolean isSequenceBatchMode() {
        return this.sequenceBatchMode;
    }

    public void setSequenceBatchMode(boolean sequenceBatchMode) {
        this.sequenceBatchMode = sequenceBatchMode;
    }

    public boolean isSupportsNativeIlike() {
        return this.supportsNativeIlike;
    }

    public boolean isSupportsDeleteTableAlias() {
        return this.supportsDeleteTableAlias;
    }

    public boolean isCaseSensitiveCollation() {
        return this.caseSensitiveCollation;
    }

    public boolean isSupportsSavepointId() {
        return this.supportsSavepointId;
    }

    public boolean isInlineSqlUpdateLimit() {
        return this.inlineSqlUpdateLimit;
    }

    public int getMaxTableNameLength() {
        return this.maxTableNameLength;
    }

    public int getMaxConstraintNameLength() {
        return this.maxConstraintNameLength;
    }

    public boolean useExtraTransactionOnIterateSecondaryQueries() {
        return this.useExtraTransactionOnIterateSecondaryQueries;
    }

    public PlatformIdGenerator createSequenceIdGenerator(BackgroundExecutor be, DataSource ds, int stepSize, String seqName) {
        return null;
    }

    public OnQueryOnly getOnQueryOnly() {
        return this.onQueryOnly;
    }

    public void setOnQueryOnly(OnQueryOnly onQueryOnly) {
        this.onQueryOnly = onQueryOnly;
    }

    public DbEncrypt getDbEncrypt() {
        return this.dbEncrypt;
    }

    public void setDbEncrypt(DbEncrypt dbEncrypt) {
        this.dbEncrypt = dbEncrypt;
    }

    public DbHistorySupport getHistorySupport() {
        return this.historySupport;
    }

    public void setHistorySupport(DbHistorySupport historySupport) {
        this.historySupport = historySupport;
    }

    public boolean isNativeArrayType() {
        return false;
    }

    public boolean isNativeUuidType() {
        return this.nativeUuidType;
    }

    public DbPlatformTypeMapping getDbTypeMap() {
        return this.dbTypeMap;
    }

    public DbDefaultValue getDbDefaultValue() {
        return this.dbDefaultValue;
    }

    public String getColumnAliasPrefix() {
        return this.columnAliasPrefix;
    }

    public void setColumnAliasPrefix(String columnAliasPrefix) {
        this.columnAliasPrefix = columnAliasPrefix;
    }

    public String getCloseQuote() {
        return this.closeQuote;
    }

    public String getOpenQuote() {
        return this.openQuote;
    }

    public int getBooleanDbType() {
        return this.booleanDbType;
    }

    public int getBlobDbType() {
        return this.blobDbType;
    }

    public int getClobDbType() {
        return this.clobDbType;
    }

    public boolean isTreatEmptyStringsAsNull() {
        return this.treatEmptyStringsAsNull;
    }

    public boolean isIdInExpandedForm() {
        return this.idInExpandedForm;
    }

    public boolean isForwardOnlyHintOnFindIterate() {
        return this.forwardOnlyHintOnFindIterate;
    }

    public void setForwardOnlyHintOnFindIterate(boolean forwardOnlyHintOnFindIterate) {
        this.forwardOnlyHintOnFindIterate = forwardOnlyHintOnFindIterate;
    }

    public boolean isSupportsResultSetConcurrencyModeUpdatable() {
        return this.supportsResultSetConcurrencyModeUpdatable;
    }

    public void setSupportsResultSetConcurrencyModeUpdatable(boolean supportsResultSetConcurrencyModeUpdatable) {
        this.supportsResultSetConcurrencyModeUpdatable = supportsResultSetConcurrencyModeUpdatable;
    }

    public boolean isDdlAutoCommit() {
        return false;
    }

    public DbIdentity getDbIdentity() {
        return this.dbIdentity;
    }

    public SqlLimiter getSqlLimiter() {
        return this.sqlLimiter;
    }

    public BasicSqlLimiter getBasicSqlLimiter() {
        return this.basicSqlLimiter;
    }

    public void setDbTrueLiteral(String dbTrueLiteral) {
        this.dbDefaultValue.setTrue(dbTrueLiteral);
    }

    public void setDbFalseLiteral(String dbFalseLiteral) {
        this.dbDefaultValue.setFalse(dbFalseLiteral);
    }

    public String convertQuotedIdentifiers(String dbName) {
        if (dbName != null && !dbName.isEmpty()) {
            if (dbName.charAt(0) == '`') {
                if (dbName.charAt(dbName.length() - 1) == '`') {
                    return this.openQuote + dbName.substring(1, dbName.length() - 1) + this.closeQuote;
                }
                logger.error("Missing backquote on [" + dbName + "]");
            } else if (this.allQuotedIdentifiers) {
                return this.openQuote + dbName + this.closeQuote;
            }
        }
        return dbName;
    }

    public String unQuote(String dbName) {
        if (dbName != null && !dbName.isEmpty() && dbName.startsWith(this.openQuote)) {
            return dbName.substring(1, dbName.length() - 1);
        }
        return dbName;
    }

    public boolean isSelectCountWithAlias() {
        return this.selectCountWithAlias;
    }

    public boolean isSelectCountWithColumnAlias() {
        return this.selectCountWithColumnAlias;
    }

    public String completeSql(String sql, Query<?> query) {
        if (query.isForUpdate()) {
            sql = this.withForUpdate(sql, query.getForUpdateLockWait(), query.getForUpdateLockType());
        }
        return sql;
    }

    public String fromForUpdate(Query.LockWait lockWait) {
        return null;
    }

    protected String withForUpdate(String sql, Query.LockWait lockWait, Query.LockType lockType) {
        logger.info("it seems your database does not support the 'for update' clause");
        return sql;
    }

    public String getLikeClause(boolean rawLikeExpression) {
        return rawLikeExpression ? this.likeClauseRaw : this.likeClauseEscaped;
    }

    public PersistBatch getPersistBatchOnCascade() {
        return this.persistBatchOnCascade;
    }

    public String truncateStatement(String table) {
        return String.format(this.truncateTable, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchemaIfNotExists(String dbSchema, Connection connection) throws SQLException {
        if (!this.schemaExists(dbSchema, connection)) {
            Statement query = connection.createStatement();
            try {
                logger.info("create schema:{}", (Object)dbSchema);
                query.executeUpdate("create schema " + dbSchema);
            }
            finally {
                JdbcClose.close(query);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean schemaExists(String dbSchema, Connection connection) throws SQLException {
        ResultSet schemas = connection.getMetaData().getSchemas();
        try {
            while (schemas.next()) {
                String schema = schemas.getString(1);
                if (!schema.equalsIgnoreCase(dbSchema)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            JdbcClose.close(schemas);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(Connection connection, String catalog, String schema, String table) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        ResultSet tables = metaData.getTables(catalog, schema, table, null);
        try {
            boolean bl = tables.next();
            return bl;
        }
        finally {
            JdbcClose.close(tables);
        }
    }

    public boolean tablePartitionsExist(Connection connection, String table) throws SQLException {
        return true;
    }

    public String tablePartitionInit(String tableName, PartitionMode mode, String property, String singlePrimaryKey) {
        return null;
    }

    public String escapeLikeString(String value) {
        StringBuilder sb = null;
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            boolean escaped = false;
            for (char escapeChar : this.likeSpecialCharacters) {
                if (ch != escapeChar) continue;
                if (sb == null) {
                    sb = new StringBuilder(value.substring(0, i));
                }
                this.escapeLikeCharacter(escapeChar, sb);
                escaped = true;
                break;
            }
            if (escaped || sb == null) continue;
            sb.append(ch);
        }
        if (sb == null) {
            return value;
        }
        return sb.toString();
    }

    protected void escapeLikeCharacter(char ch, StringBuilder sb) {
        sb.append(this.likeEscapeChar).append(ch);
    }

    public static enum OnQueryOnly {
        ROLLBACK,
        COMMIT;

    }
}

