/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config.dbplatform.oracle;

import io.ebean.config.dbplatform.AbstractDbEncrypt;
import io.ebean.config.dbplatform.DbEncryptFunction;

public class OracleDbEncrypt
extends AbstractDbEncrypt {
    public OracleDbEncrypt() {
        this("eb_encrypt", "eb_decrypt");
    }

    public OracleDbEncrypt(String encryptFunction, String decryptFunction) {
        this.varcharEncryptFunction = new OraVarcharFunction(encryptFunction, decryptFunction);
        this.dateEncryptFunction = new OraDateFunction(encryptFunction, decryptFunction);
    }

    private static class OraDateFunction
    implements DbEncryptFunction {
        private final String encryptfunction;
        private final String decryptfunction;

        public OraDateFunction(String encryptfunction, String decryptfunction) {
            this.encryptfunction = encryptfunction;
            this.decryptfunction = decryptfunction;
        }

        @Override
        public String getDecryptSql(String columnWithTableAlias) {
            return "to_date(" + this.decryptfunction + "(" + columnWithTableAlias + ",?),'YYYYMMDD')";
        }

        @Override
        public String getEncryptBindSql() {
            return this.encryptfunction + "(to_char(?,'YYYYMMDD'),?)";
        }
    }

    private static class OraVarcharFunction
    implements DbEncryptFunction {
        private final String encryptfunction;
        private final String decryptfunction;

        public OraVarcharFunction(String encryptfunction, String decryptfunction) {
            this.encryptfunction = encryptfunction;
            this.decryptfunction = decryptfunction;
        }

        @Override
        public String getDecryptSql(String columnWithTableAlias) {
            return this.decryptfunction + "(" + columnWithTableAlias + ",?)";
        }

        @Override
        public String getEncryptBindSql() {
            return this.encryptfunction + "(?,?)";
        }
    }
}

