/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config.dbplatform;

import io.ebean.AcquireLockException;
import io.ebean.DataIntegrityException;
import io.ebean.DuplicateKeyException;
import io.ebean.SerializableConflictException;
import io.ebean.config.dbplatform.DataErrorType;
import io.ebean.config.dbplatform.SqlExceptionTranslator;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import javax.persistence.PersistenceException;

public class SqlCodeTranslator
implements SqlExceptionTranslator {
    private final Map<String, DataErrorType> map;

    public SqlCodeTranslator(Map<String, DataErrorType> map) {
        this.map = map;
    }

    public SqlCodeTranslator() {
        this.map = Collections.emptyMap();
    }

    @Override
    public PersistenceException translate(String message, SQLException e) {
        DataErrorType errorType = this.map.get(e.getSQLState());
        if (errorType == null) {
            errorType = this.map.get(String.valueOf(e.getErrorCode()));
        }
        if (errorType != null) {
            switch (errorType) {
                case AcquireLock: {
                    return new AcquireLockException(message, e);
                }
                case DuplicateKey: {
                    return new DuplicateKeyException(message, e);
                }
                case DataIntegrity: {
                    return new DataIntegrityException(message, e);
                }
                case SerializableConflict: {
                    return new SerializableConflictException(message, e);
                }
            }
        }
        return new PersistenceException(message, (Throwable)e);
    }
}

