/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.config;

public class DbConstraintNormalise {
    protected final String[] quotedIdentifiers;
    protected final boolean lowerCaseTables;
    protected final boolean lowerCaseColumns;

    public DbConstraintNormalise() {
        this(true, true);
    }

    public DbConstraintNormalise(boolean lowerCaseTables, boolean lowerCaseColumns) {
        this.lowerCaseTables = lowerCaseTables;
        this.lowerCaseColumns = lowerCaseColumns;
        this.quotedIdentifiers = new String[]{"\"", "'", "[", "]", "`"};
    }

    public String normaliseTable(String tableName) {
        int lastPeriod = (tableName = this.trimQuotes(tableName)).lastIndexOf(46);
        if (lastPeriod > -1) {
            tableName = tableName.substring(lastPeriod + 1);
        }
        if (this.lowerCaseTables) {
            tableName = tableName.toLowerCase();
        }
        return tableName;
    }

    public String normaliseColumn(String columnName) {
        columnName = this.trimBrackets(this.trimQuotes(columnName));
        if (this.lowerCaseColumns) {
            columnName = columnName.toLowerCase();
        }
        return columnName;
    }

    private String trimBrackets(String value) {
        return value.replace("(", "").replace(")", "");
    }

    public String lowerTableName(String tableName) {
        if (this.lowerCaseTables && this.notQuoted(tableName)) {
            return tableName.toLowerCase();
        }
        return tableName;
    }

    public String lowerColumnName(String name) {
        if (this.lowerCaseColumns && this.notQuoted(name)) {
            return name.toLowerCase();
        }
        return name;
    }

    public boolean notQuoted(String tableName) {
        for (String quotedIdentifier : this.quotedIdentifiers) {
            if (!tableName.contains(quotedIdentifier)) continue;
            return false;
        }
        return true;
    }

    public String trimQuotes(String tableName) {
        if (tableName == null) {
            return "";
        }
        for (String quotedIdentifier : this.quotedIdentifiers) {
            tableName = tableName.replace(quotedIdentifier, "");
        }
        return tableName;
    }
}

