/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.bean;

import io.ebean.bean.ObjectGraphOrigin;
import java.io.Serializable;
import java.util.Objects;

public final class ObjectGraphNode
implements Serializable {
    private static final long serialVersionUID = 2087081778650228996L;
    private final ObjectGraphOrigin originQueryPoint;
    private final String path;

    public ObjectGraphNode(ObjectGraphNode parent, String path) {
        this.originQueryPoint = parent.getOriginQueryPoint();
        this.path = parent.getChildPath(path);
    }

    public ObjectGraphNode(ObjectGraphOrigin originQueryPoint, String path) {
        this.originQueryPoint = originQueryPoint;
        this.path = path;
    }

    public ObjectGraphOrigin getOriginQueryPoint() {
        return this.originQueryPoint;
    }

    private String getChildPath(String childPath) {
        if (this.path == null) {
            return childPath;
        }
        if (childPath == null) {
            return this.path;
        }
        return this.path + "." + childPath;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return "origin:" + this.originQueryPoint + " path[" + this.path + "]";
    }

    public int hashCode() {
        int hc = 92821 * this.originQueryPoint.hashCode();
        hc = 92821 * hc + (this.path == null ? 0 : this.path.hashCode());
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObjectGraphNode)) {
            return false;
        }
        ObjectGraphNode e = (ObjectGraphNode)obj;
        return Objects.equals(e.path, this.path) && e.originQueryPoint.equals(this.originQueryPoint);
    }
}

