/*
 * Decompiled with CFR 0.152.
 */
package io.confound.convert;

import io.confound.convert.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberConverter
implements Converter<Number> {
    public static final NumberConverter INSTANCE = new NumberConverter();

    protected NumberConverter() {
    }

    @Override
    public boolean supportsConvert(Class<?> fromType, Class<?> toType) throws IllegalArgumentException {
        return Number.class.isAssignableFrom(fromType) && Number.class.isAssignableFrom(toType);
    }

    @Override
    public <T extends Number> T convert(Object object, Class<T> convertType) throws IllegalArgumentException {
        Class<?> objectType = object.getClass();
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException(String.format("Number converter cannot convert from non-number type %s.", objectType));
        }
        if (convertType.isAssignableFrom(objectType)) {
            return (T)((Number)convertType.cast(object));
        }
        Number number = (Number)object;
        if (Integer.class.isAssignableFrom(convertType)) {
            return (T)((Number)convertType.cast(number.intValue()));
        }
        if (Long.class.isAssignableFrom(convertType)) {
            return (T)((Number)convertType.cast(number.longValue()));
        }
        if (Double.class.isAssignableFrom(convertType)) {
            return (T)((Number)convertType.cast(number.doubleValue()));
        }
        if (Float.class.isAssignableFrom(convertType)) {
            return (T)((Number)convertType.cast(Float.valueOf(number.floatValue())));
        }
        if (Short.class.isAssignableFrom(convertType)) {
            return (T)((Number)convertType.cast(number.shortValue()));
        }
        if (Byte.class.isAssignableFrom(convertType)) {
            return (T)((Number)convertType.cast(number.byteValue()));
        }
        if (BigInteger.class.isAssignableFrom(convertType)) {
            return (T)((Number)convertType.cast(BigInteger.valueOf(number.longValue())));
        }
        if (BigDecimal.class.isAssignableFrom(convertType)) {
            return (T)((Number)convertType.cast(BigDecimal.valueOf(number.doubleValue())));
        }
        throw new IllegalArgumentException(String.format("Number converter does not support conversion to %s.", convertType));
    }
}

