/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config.load;

import io.avaje.config.load.LoadContext;
import java.io.InputStream;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

class YamlLoader {
    private final Yaml yaml = new Yaml();
    private final LoadContext loadContext;

    YamlLoader(LoadContext loadContext) {
        this.loadContext = loadContext;
    }

    void load(InputStream is) {
        for (Object map : this.yaml.loadAll(is)) {
            this.loadMap((Map)map, null);
        }
    }

    void loadMap(Map<String, Object> map, String path) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object val;
            String key = entry.getKey();
            if (path != null) {
                key = path + "." + key;
            }
            if ((val = entry.getValue()) instanceof Map) {
                this.loadMap((Map)val, key);
                continue;
            }
            this.addScalar(key, val);
        }
    }

    private void addScalar(String key, Object val) {
        if (val instanceof String) {
            this.loadContext.put(key, (String)val);
        } else if (val instanceof Number || val instanceof Boolean) {
            this.loadContext.put(key, val.toString());
        }
    }
}

