/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config.load;

import io.avaje.config.Configuration;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

class CoreExpressionEval
implements Configuration.ExpressionEval {
    private static final String JAVA_COMP_ENV = "java:comp/env/";
    private static final String START = "${";
    private static final String END = "}";
    private Map<String, String> sourceMap;
    private Properties sourceProperties;

    CoreExpressionEval(Map<String, String> sourceMap) {
        this.sourceMap = sourceMap;
    }

    CoreExpressionEval(Properties sourceProperties) {
        this.sourceProperties = sourceProperties;
    }

    @Override
    public String eval(String val) {
        int ep;
        if (val == null) {
            return null;
        }
        int sp = val.indexOf(START);
        if (sp > -1 && (ep = val.indexOf(END, sp + 1)) > -1) {
            return this.eval(val, sp, ep);
        }
        return val;
    }

    private String evaluateExpression(String exp) {
        String val = System.getProperty(exp);
        if (val == null) {
            val = System.getenv(exp);
            if (val == null) {
                val = this.localLookup(exp);
            }
            if (val == null && this.isJndiExpression(exp) && (val = this.getJndiProperty(exp)) != null) {
                return val;
            }
        }
        return val;
    }

    private String localLookup(String exp) {
        if (this.sourceMap != null) {
            return this.sourceMap.get(exp);
        }
        if (this.sourceProperties != null) {
            return this.sourceProperties.getProperty(exp);
        }
        return null;
    }

    private String eval(String val, int sp, int ep) {
        return new EvalBuffer(val, sp, ep).process();
    }

    private boolean isJndiExpression(String exp) {
        return exp.startsWith("JNDI:") || exp.startsWith("jndi:");
    }

    private String getJndiProperty(String key) {
        try {
            key = key.substring(5);
            return (String)this.getJndiObject(key);
        }
        catch (NamingException ex) {
            return null;
        }
    }

    private Object getJndiObject(String key) throws NamingException {
        InitialContext ctx = new InitialContext();
        return ctx.lookup(JAVA_COMP_ENV + key);
    }

    private class EvalBuffer {
        private final StringBuilder buf = new StringBuilder();
        private final String original;
        private int position;
        private int start;
        private int end;
        private String expression;
        private String defaultValue;

        EvalBuffer(String val, int start, int ep) {
            this.original = val;
            this.start = start;
            this.end = ep;
            this.position = 0;
            this.moveToStart();
        }

        void moveToStart() {
            if (this.start > this.position) {
                this.buf.append(this.original, this.position, this.start);
                this.position = this.start;
            }
        }

        void parseForDefault() {
            int colonPos = this.original.indexOf(58, this.start);
            if (colonPos > this.start && colonPos < this.end) {
                this.expression = this.original.substring(this.start + CoreExpressionEval.START.length(), colonPos);
                this.defaultValue = this.original.substring(colonPos + 1, this.end);
            } else {
                this.expression = this.original.substring(this.start + CoreExpressionEval.START.length(), this.end);
            }
        }

        void evaluate() {
            String eval = CoreExpressionEval.this.evaluateExpression(this.expression);
            if (eval != null) {
                this.buf.append(eval);
            } else if (this.defaultValue != null) {
                this.buf.append(this.defaultValue);
            } else {
                this.buf.append(CoreExpressionEval.START).append(this.expression).append(CoreExpressionEval.END);
            }
        }

        String end() {
            if (this.end < this.original.length() - 1) {
                this.buf.append(this.original.substring(this.end + 1));
            }
            return this.buf.toString();
        }

        boolean next() {
            int endPos;
            int startPos;
            if (this.end < this.original.length() && (startPos = this.original.indexOf(CoreExpressionEval.START, this.end + 1)) > -1 && (endPos = this.original.indexOf(CoreExpressionEval.END, startPos + 1)) > -1) {
                if (startPos > this.end + 1) {
                    this.buf.append(this.original, this.end + 1, startPos);
                }
                this.start = startPos;
                this.end = endPos;
                return true;
            }
            return false;
        }

        private void evalNext() {
            this.parseForDefault();
            this.evaluate();
        }

        String process() {
            this.evalNext();
            while (this.next()) {
                this.evalNext();
            }
            return this.end();
        }
    }
}

