/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.classpath.scanner.core;

public final class Location {
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String FILESYSTEM_PREFIX = "filesystem:";
    private final String prefix;
    private String path;

    public Location(String descriptor) {
        String normalizedDescriptor = descriptor.trim().replace("\\", "/");
        int colonPos = normalizedDescriptor.indexOf(":");
        if (colonPos > -1) {
            this.prefix = normalizedDescriptor.substring(0, colonPos + 1);
            this.path = normalizedDescriptor.substring(colonPos + 1);
        } else {
            this.prefix = CLASSPATH_PREFIX;
            this.path = normalizedDescriptor;
        }
        if (this.isClassPath()) {
            this.path = this.path.replace(".", "/");
            if (this.path.startsWith("/")) {
                this.path = this.path.substring(1);
            }
        } else if (!this.isFileSystem()) {
            throw new IllegalStateException("Unknown prefix, should be either filesystem: or classpath: " + normalizedDescriptor);
        }
        if (this.path.endsWith("/")) {
            this.path = this.path.substring(0, this.path.length() - 1);
        }
    }

    public boolean isClassPath() {
        return CLASSPATH_PREFIX.equals(this.prefix);
    }

    public boolean isFileSystem() {
        return FILESYSTEM_PREFIX.equals(this.prefix);
    }

    public String path() {
        return this.path;
    }

    public String prefix() {
        return this.prefix;
    }

    public String descriptor() {
        return this.prefix + this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        return this.descriptor().equals(location.descriptor());
    }

    public int hashCode() {
        return this.descriptor().hashCode();
    }

    public String toString() {
        return this.descriptor();
    }
}

