/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.classpath.scanner.internal.scanner.filesystem;

import io.avaje.classpath.scanner.Resource;
import io.avaje.classpath.scanner.ResourceFilter;
import io.avaje.classpath.scanner.core.ClassPathScanException;
import io.avaje.classpath.scanner.core.Location;
import io.avaje.classpath.scanner.internal.scanner.filesystem.FileSystemResource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemScanner {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemScanner.class);

    public List<Resource> scanForResources(Location location, ResourceFilter predicate) {
        String path = location.getPath();
        File dir = new File(path);
        if (!dir.isDirectory() || !dir.canRead()) {
            LOG.debug("Unable to resolve location filesystem:{}", (Object)path);
            return Collections.emptyList();
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        try {
            Set<String> resourceNames = this.findResourceNames(path, predicate);
            for (String resourceName : resourceNames) {
                resources.add(new FileSystemResource(resourceName));
                LOG.debug("Found filesystem resource: " + resourceName);
            }
            return resources;
        }
        catch (Exception e) {
            throw new ClassPathScanException(e);
        }
    }

    private Set<String> findResourceNames(String path, ResourceFilter predicate) {
        Set<String> resourceNames = this.findResourceNamesFromFileSystem(path, new File(path));
        return this.filterResourceNames(resourceNames, predicate);
    }

    Set<String> findResourceNamesFromFileSystem(String scanRootLocation, File folder) {
        LOG.debug("scanning in path: {} ({})", (Object)folder.getPath(), (Object)scanRootLocation);
        TreeSet<String> resourceNames = new TreeSet<String>();
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.canRead()) continue;
                if (file.isDirectory()) {
                    resourceNames.addAll(this.findResourceNamesFromFileSystem(scanRootLocation, file));
                    continue;
                }
                resourceNames.add(file.getPath());
            }
        }
        return resourceNames;
    }

    private Set<String> filterResourceNames(Set<String> resourceNames, ResourceFilter predicate) {
        TreeSet<String> filteredResourceNames = new TreeSet<String>();
        for (String resourceName : resourceNames) {
            if (!predicate.isMatch(resourceName)) continue;
            filteredResourceNames.add(resourceName);
        }
        return filteredResourceNames;
    }
}

