/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.classpath.scanner.internal.scanner.filesystem;

import io.avaje.classpath.scanner.Resource;
import io.avaje.classpath.scanner.core.ClassPathScanException;
import io.avaje.classpath.scanner.internal.FileCopyUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

class FileSystemResource
implements Resource,
Comparable<FileSystemResource> {
    private final File location;

    public FileSystemResource(String location) {
        this.location = new File(location);
    }

    public String toString() {
        return this.location.toString();
    }

    public String getLocation() {
        return this.location.getPath().replace('\\', '/');
    }

    public String getLocationOnDisk() {
        return this.location.getAbsolutePath();
    }

    public String loadAsString(String encoding) {
        try {
            FileInputStream inputStream = new FileInputStream(this.location);
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, Charset.forName(encoding));
            return FileCopyUtils.copyToString(reader);
        }
        catch (IOException e) {
            throw new ClassPathScanException("Unable to load filesystem resource: " + this.location.getPath() + " (encoding: " + encoding + ")", e);
        }
    }

    public byte[] loadAsBytes() {
        try {
            FileInputStream inputStream = new FileInputStream(this.location);
            return FileCopyUtils.copyToByteArray(inputStream);
        }
        catch (IOException e) {
            throw new ClassPathScanException("Unable to load filesystem resource: " + this.location.getPath(), e);
        }
    }

    public String getFilename() {
        return this.location.getName();
    }

    @Override
    public int compareTo(FileSystemResource o) {
        return this.location.compareTo(o.location);
    }
}

