/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.classpath.scanner.internal.scanner.classpath.android;

import android.content.Context;
import dalvik.system.DexFile;
import dalvik.system.PathClassLoader;
import io.avaje.classpath.scanner.ClassFilter;
import io.avaje.classpath.scanner.Resource;
import io.avaje.classpath.scanner.ResourceFilter;
import io.avaje.classpath.scanner.andriod.ContextHolder;
import io.avaje.classpath.scanner.core.ClassPathScanException;
import io.avaje.classpath.scanner.core.Location;
import io.avaje.classpath.scanner.internal.ResourceAndClassScanner;
import io.avaje.classpath.scanner.internal.scanner.classpath.android.AndroidResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidScanner
implements ResourceAndClassScanner {
    private static final Logger LOG = LoggerFactory.getLogger(AndroidScanner.class);
    private final Context context;
    private final PathClassLoader classLoader;

    public AndroidScanner(ClassLoader classLoader) {
        this.classLoader = (PathClassLoader)classLoader;
        this.context = ContextHolder.getContext();
        if (this.context == null) {
            throw new ClassPathScanException("Unable to create scanner. Within an activity you can fix this with org.avaje.classpath.scanner.android.ContextHolder.setContext(this);");
        }
    }

    @Override
    public List<Resource> scanForResources(Location location, ResourceFilter predicate) {
        try {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            String path = location.getPath();
            for (String asset : this.context.getAssets().list(path)) {
                if (!predicate.isMatch(asset)) continue;
                resources.add(new AndroidResource(this.context.getAssets(), path, asset));
            }
            return resources;
        }
        catch (IOException e) {
            throw new ClassPathScanException(e);
        }
    }

    @Override
    public List<Class<?>> scanForClasses(Location location, ClassFilter predicate) {
        try {
            String pkg = location.getPath().replace("/", ".");
            ArrayList classes = new ArrayList();
            DexFile dex = new DexFile(this.context.getApplicationInfo().sourceDir);
            Enumeration entries = dex.entries();
            while (entries.hasMoreElements()) {
                Class clazz;
                String className = (String)entries.nextElement();
                if (!className.startsWith(pkg) || !predicate.isMatch(clazz = this.classLoader.loadClass(className))) continue;
                classes.add(clazz);
                LOG.trace("... found class: {}", (Object)className);
            }
            return classes;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new ClassPathScanException(e);
        }
    }
}

