/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.spi;

import io.avaje.inject.spi.DEntry;
import io.avaje.inject.spi.KeyUtil;
import jakarta.inject.Provider;
import java.util.Objects;

class DContextEntryBean {
    protected final Object source;
    protected final String name;
    private final int flag;

    static DContextEntryBean of(Object source, String name, int flag) {
        if (source instanceof Provider) {
            return new ProtoProvider((Provider)source, name, flag);
        }
        return new DContextEntryBean(source, name, flag);
    }

    static DContextEntryBean supplied(Object source, String name, int flag) {
        if (source instanceof Provider) {
            return new OnceProvider((Provider)source, name, flag);
        }
        return new DContextEntryBean(source, name, flag);
    }

    static DContextEntryBean provider(boolean prototype, Provider<?> provider, String name, int flag) {
        return prototype ? new ProtoProvider(provider, name, flag) : new OnceProvider(provider, name, flag);
    }

    private DContextEntryBean(Object source, String name, int flag) {
        this.source = source;
        this.name = KeyUtil.lower(name);
        this.flag = flag;
    }

    public final String toString() {
        return "Bean{source=" + String.valueOf(this.source) + ", name='" + this.name + "', flag=" + this.flag + "}";
    }

    final DEntry entry() {
        return new DEntry(this.name, this.flag, this.bean());
    }

    final boolean isNameMatch(String qualifierName) {
        return qualifierName == null || qualifierName.equals(this.name);
    }

    final boolean isNameEqual(String qualifierName) {
        return Objects.equals(qualifierName, this.name);
    }

    Object beanIfNameMatch(String name) {
        return this.isNameMatch(name) ? this.bean() : null;
    }

    String name() {
        return this.name;
    }

    Object bean() {
        return this.source;
    }

    Provider<?> provider() {
        return this::bean;
    }

    final boolean isPrimary() {
        return this.flag == 1;
    }

    final boolean isSecondary() {
        return this.flag == -1;
    }

    final boolean isSupplied() {
        return this.flag == 2;
    }

    final boolean isSupplied(String qualifierName) {
        return this.flag == 2 && (qualifierName == null || qualifierName.equals(this.name));
    }

    static final class ProtoProvider
    extends DContextEntryBean {
        private final Provider<?> provider;

        private ProtoProvider(Provider<?> provider, String name, int flag) {
            super(provider, name, flag);
            this.provider = provider;
        }

        @Override
        Provider<?> provider() {
            return this.provider;
        }

        @Override
        Object bean() {
            return this.provider.get();
        }
    }

    static final class OnceProvider
    extends DContextEntryBean {
        private final Provider<?> provider;
        private Object bean;

        private OnceProvider(Provider<?> provider, String name, int flag) {
            super(provider, name, flag);
            this.provider = provider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Object bean() {
            OnceProvider onceProvider = this;
            synchronized (onceProvider) {
                if (this.bean == null) {
                    this.bean = this.provider.get();
                }
                return this.bean;
            }
        }
    }
}

