/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config;

import io.avaje.config.ConfigParser;
import io.avaje.config.Configuration;
import io.avaje.config.ConfigurationLog;
import io.avaje.config.CoreConfiguration;
import io.avaje.config.CoreEntry;
import io.avaje.config.CoreExpressionEval;
import io.avaje.config.FileWatch;
import io.avaje.config.InitialLoadContext;
import io.avaje.config.Parsers;
import io.avaje.config.ResourceLoader;
import io.avaje.lang.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

final class InitialLoader {
    private static final Pattern SPLIT_PATHS = Pattern.compile("[\\s,;]+");
    private final ConfigurationLog log;
    private final InitialLoadContext loadContext;
    private final Set<String> profileResourceLoaded = new HashSet<String>();
    private final Parsers parsers;

    public static Configuration.ExpressionEval evalFor(Properties properties) {
        return new CoreExpressionEval(properties);
    }

    InitialLoader(ConfigurationLog log, ResourceLoader resourceLoader) {
        this.log = log;
        this.loadContext = new InitialLoadContext(log, resourceLoader);
        this.parsers = new Parsers();
    }

    Set<String> loadedFrom() {
        return this.loadContext.loadedFrom();
    }

    CoreEntry.CoreMap load() {
        this.loadEnvironmentVars();
        this.loadLocalFiles();
        return this.entryMap();
    }

    void initWatcher(CoreConfiguration configuration) {
        if (configuration.getBool("config.watch.enabled", false)) {
            configuration.setWatcher(new FileWatch(configuration, this.loadContext.loadedFiles(), this.parsers));
        }
    }

    void loadEnvironmentVars() {
        this.loadContext.loadEnvironmentVars();
    }

    void loadLocalFiles() {
        this.loadMain(Source.RESOURCE);
        this.loadViaProfiles(Source.RESOURCE);
        this.loadMain(Source.FILE);
        this.loadViaProfiles(Source.RESOURCE);
        this.loadViaProfiles(Source.FILE);
        this.loadViaSystemProperty();
        this.loadViaIndirection();
        if (!this.loadTest()) {
            this.loadLocalDev();
        }
        this.loadViaCommandLineArgs();
    }

    private void loadViaCommandLineArgs() {
        String rawArgs = System.getProperty("sun.java.command");
        if (rawArgs != null) {
            this.loadViaCommandLine(rawArgs.split(" "));
        }
    }

    void loadViaCommandLine(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("-P") && !arg.startsWith("-p")) continue;
            if (arg.length() == 2 && i < args.length - 1) {
                this.loadCommandLineArg(args[++i]);
                continue;
            }
            this.loadCommandLineArg(arg.substring(2));
        }
    }

    private void loadCommandLineArg(String arg) {
        if (this.isValidExtension(arg)) {
            this.loadViaPaths(arg);
        }
    }

    private boolean isValidExtension(String arg) {
        String extension = arg.substring(arg.lastIndexOf(".") + 1);
        return "properties".equals(extension) || this.parsers.supportsExtension(extension);
    }

    private void loadLocalDev() {
        String appName;
        File localDev = new File(System.getProperty("user.home"), ".localdev");
        if (localDev.exists() && (appName = this.loadContext.getAppName()) != null) {
            String prefix = localDev.getAbsolutePath() + File.separator + appName;
            this.load(prefix, Source.FILE);
        }
    }

    private boolean loadTest() {
        if (Boolean.getBoolean("suppressTestResource")) {
            return false;
        }
        int before = this.loadContext.size();
        this.load("application-test", Source.RESOURCE);
        if (this.loadProperties("test-ebean.properties", Source.RESOURCE)) {
            this.log.log(System.Logger.Level.WARNING, "Loading properties from test-ebean.properties is deprecated. Please migrate to application-test.yaml or application-test.properties instead.", new Object[0]);
        }
        return this.loadContext.size() > before;
    }

    private void loadViaIndirection() {
        String paths = this.loadContext.indirectLocation();
        if (paths != null) {
            this.loadViaPaths(paths);
        }
    }

    @Nullable
    private String[] profiles() {
        String paths = this.loadContext.profiles();
        return paths == null ? null : this.splitPaths(paths);
    }

    private void loadViaProfiles(Source source) {
        String[] profiles = this.profiles();
        if (profiles != null) {
            for (String path : profiles) {
                String profile = this.loadContext.eval(path);
                if (source == Source.RESOURCE && this.profileResourceLoaded.contains(profile) || !this.load("application-" + profile, source)) continue;
                this.profileResourceLoaded.add(profile);
            }
        }
    }

    private void loadViaPaths(String paths) {
        for (String path : this.splitPaths(paths)) {
            this.loadWithExtensionCheck(this.loadContext.eval(path));
        }
    }

    int size() {
        return this.loadContext.size();
    }

    String[] splitPaths(String location) {
        return SPLIT_PATHS.split(location);
    }

    private void loadMain(Source source) {
        this.load("application", source);
        if (this.loadProperties("ebean.properties", source)) {
            this.log.log(System.Logger.Level.WARNING, "Loading properties from ebean.properties is deprecated. Please migrate to use application.yaml or application.properties instead.", new Object[0]);
        }
    }

    private void loadViaSystemProperty() {
        String fileName = System.getenv("PROPS_FILE");
        if (fileName == null && (fileName = System.getProperty("props.file")) != null && !this.loadWithExtensionCheck(fileName)) {
            this.log.log(System.Logger.Level.WARNING, "Unable to find file {0} to load properties", fileName);
        }
    }

    boolean loadWithExtensionCheck(String fileName) {
        String extension = fileName.substring(fileName.lastIndexOf(".") + 1);
        if ("properties".equals(extension)) {
            return this.loadProperties(fileName, Source.RESOURCE) | this.loadProperties(fileName, Source.FILE);
        }
        ConfigParser parser = this.parsers.get(extension);
        if (parser == null) {
            throw new IllegalArgumentException("Expecting only properties or " + String.valueOf(this.parsers.supportedExtensions()) + " file extensions but got [" + fileName + "]");
        }
        return this.loadCustomExtension(fileName, parser, Source.RESOURCE) | this.loadCustomExtension(fileName, parser, Source.FILE);
    }

    CoreEntry.CoreMap entryMap() {
        return this.loadContext.entryMap();
    }

    boolean load(String resourcePath, Source source) {
        return this.loadProperties(resourcePath + ".properties", source) || this.loadCustom(resourcePath, source);
    }

    private boolean loadCustom(String resourcePath, Source source) {
        for (Map.Entry<String, ConfigParser> entry : this.parsers.entrySet()) {
            String extension = entry.getKey();
            if (!this.loadCustomExtension(resourcePath + "." + extension, entry.getValue(), source)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean loadCustomExtension(String resourcePath, ConfigParser parser, Source source) {
        try (InputStream is = this.resource(resourcePath, source);){
            if (is == null) return false;
            parser.load(is).forEach((k, v) -> this.loadContext.put((String)k, (String)v, (source == Source.RESOURCE ? "resource:" : "file:") + resourcePath));
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error loading properties - " + resourcePath, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean loadProperties(String resourcePath, Source source) {
        try (InputStream is = this.resource(resourcePath, source);){
            if (is == null) return false;
            this.loadProperties(is, (source == Source.RESOURCE ? "resource:" : "file") + resourcePath);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error loading properties - " + resourcePath, e);
        }
    }

    private InputStream resource(String resourcePath, Source source) {
        return this.loadContext.resource(resourcePath, source);
    }

    private void loadProperties(InputStream is, String source) throws IOException {
        Properties properties = new Properties();
        properties.load(is);
        this.put(properties, source);
    }

    private void put(Properties properties, String source) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String val = properties.getProperty(key);
            this.loadContext.put(key, val, source);
        }
    }

    static enum Source {
        RESOURCE,
        FILE;

    }
}

