/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config;

import io.avaje.config.CoreConfiguration;
import io.avaje.config.CoreEntry;
import io.avaje.config.ModificationEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

final class CoreEventBuilder
implements ModificationEvent.Builder {
    private final String name;
    private final CoreConfiguration origin;
    private final CoreEntry.CoreMap snapshot;
    private final Map<String, String> changes = new LinkedHashMap<String, String>();

    CoreEventBuilder(String name, CoreConfiguration origin, CoreEntry.CoreMap snapshot) {
        this.name = name;
        this.origin = origin;
        this.snapshot = snapshot;
    }

    @Override
    public ModificationEvent.Builder putAll(Map<String, ?> map) {
        map.forEach((key, value) -> {
            Objects.requireNonNull(value);
            this.put((String)key, value.toString());
        });
        return this;
    }

    @Override
    public ModificationEvent.Builder put(String key, String value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        value = this.origin.eval(value);
        if (this.snapshot.isChanged(key, value)) {
            this.changes.put(key, value);
        }
        return this;
    }

    @Override
    public ModificationEvent.Builder remove(String key) {
        Objects.requireNonNull(key);
        if (this.snapshot.containsKey(key)) {
            this.changes.put(key, null);
        }
        return this;
    }

    @Override
    public void publish() {
        this.origin.publishEvent(this);
    }

    boolean hasChanges() {
        return !this.changes.isEmpty();
    }

    void forEachPut(BiConsumer<String, String> consumer) {
        this.changes.forEach(consumer);
    }

    String name() {
        return this.name;
    }
}

