/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config;

import io.avaje.config.Configuration;
import io.avaje.config.CoreConfiguration;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

final class CoreSetValue
implements Configuration.SetValue {
    private final CoreConfiguration config;

    CoreSetValue(CoreConfiguration config) {
        this.config = config;
    }

    @Override
    public Set<String> of(String key) {
        String val = this.config.value(key);
        if (val == null) {
            return Collections.emptySet();
        }
        return this.split(val);
    }

    @Override
    public Set<String> of(String key, String ... defaultValues) {
        String val = this.config.value(key);
        if (val == null) {
            LinkedHashSet<String> values = new LinkedHashSet<String>();
            Collections.addAll(values, defaultValues);
            return values;
        }
        return this.split(val);
    }

    @Override
    public Set<Integer> ofInt(String key) {
        String val = this.config.value(key);
        if (val == null) {
            return Collections.emptySet();
        }
        return this.splitInt(val);
    }

    @Override
    public Set<Integer> ofInt(String key, int ... defaultValues) {
        String val = this.config.value(key);
        if (val == null) {
            LinkedHashSet<Integer> ints = new LinkedHashSet<Integer>();
            for (int defaultVal : defaultValues) {
                ints.add(defaultVal);
            }
            return ints;
        }
        return this.splitInt(val);
    }

    @Override
    public Set<Long> ofLong(String key) {
        String val = this.config.value(key);
        if (val == null) {
            return Collections.emptySet();
        }
        return this.splitLong(val);
    }

    @Override
    public Set<Long> ofLong(String key, long ... defaultValues) {
        String val = this.config.value(key);
        if (val == null) {
            LinkedHashSet<Long> ints = new LinkedHashSet<Long>();
            for (long defaultVal : defaultValues) {
                ints.add(defaultVal);
            }
            return ints;
        }
        return this.splitLong(val);
    }

    Set<String> split(String allValues) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        Collections.addAll(set, allValues.split(","));
        return set;
    }

    Set<Integer> splitInt(String allValues) {
        return this.split(allValues).stream().map(Integer::parseInt).collect(Collectors.toSet());
    }

    Set<Long> splitLong(String allValues) {
        return this.split(allValues).stream().map(Long::parseLong).collect(Collectors.toSet());
    }
}

