/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config;

import io.avaje.config.CoreEventBuilder;
import io.avaje.lang.NonNullApi;
import io.avaje.lang.Nullable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;

@NonNullApi
final class CoreEntry {
    static final CoreEntry NULL_ENTRY = new CoreEntry();
    private final String value;
    private final boolean boolValue;
    private final String source;

    static CoreMap newMap() {
        return new CoreMap();
    }

    static CoreMap newMap(Properties source, String propSource) {
        return new CoreMap(source, propSource);
    }

    static CoreEntry of(@Nullable String val, String source) {
        return val == null ? NULL_ENTRY : new CoreEntry(val, source);
    }

    private CoreEntry() {
        this.value = null;
        this.boolValue = false;
        this.source = null;
    }

    private CoreEntry(String value, String source) {
        Objects.requireNonNull(value);
        this.value = value;
        this.boolValue = Boolean.parseBoolean(value);
        this.source = source;
    }

    String value() {
        return this.value;
    }

    boolean boolValue() {
        return this.boolValue;
    }

    String source() {
        return this.source;
    }

    boolean isNull() {
        return this.value == null;
    }

    static class CoreMap {
        private final Map<String, CoreEntry> entryMap = new ConcurrentHashMap<String, CoreEntry>();

        CoreMap() {
        }

        CoreMap(Properties source, String sourceName) {
            source.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                if (value != null) {
                    this.entryMap.put(key.toString(), CoreEntry.of(value.toString(), sourceName));
                }
            }));
        }

        int size() {
            return this.entryMap.size();
        }

        @Nullable
        CoreEntry get(String key) {
            return this.entryMap.get(key);
        }

        Set<String> applyChanges(CoreEventBuilder eventBuilder) {
            HashSet<String> modifiedKeys = new HashSet<String>();
            String sourceName = "event:" + eventBuilder.name();
            eventBuilder.forEachPut((key, value) -> {
                if (value == null) {
                    if (this.entryMap.remove(key) != null) {
                        modifiedKeys.add((String)key);
                    }
                } else if (this.putIfChanged((String)key, (String)value, sourceName)) {
                    modifiedKeys.add((String)key);
                }
            });
            return modifiedKeys;
        }

        boolean isChanged(String key, String value) {
            CoreEntry entry = this.entryMap.get(key);
            return entry == null || !Objects.equals(entry.value, value);
        }

        private boolean putIfChanged(String key, String value, String source) {
            CoreEntry entry = this.entryMap.get(key);
            if (entry == null) {
                this.entryMap.put(key, CoreEntry.of(value, source));
                return true;
            }
            if (!Objects.equals(entry.value, value)) {
                this.entryMap.put(key, CoreEntry.of(value, source + " <- " + entry.source));
                return true;
            }
            return false;
        }

        boolean containsKey(String key) {
            return this.entryMap.containsKey(key);
        }

        void put(String key, CoreEntry value) {
            this.entryMap.put(key, value);
        }

        void put(String key, String value, String source) {
            this.entryMap.put(key, CoreEntry.of(value, source));
        }

        @Nullable
        String raw(String key) {
            CoreEntry entry = this.entryMap.get(key);
            return entry == null ? null : entry.value();
        }

        void forEach(BiConsumer<String, CoreEntry> consumer) {
            this.entryMap.forEach(consumer);
        }
    }
}

