/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config;

import io.avaje.config.Config;
import io.avaje.config.Configuration;
import io.avaje.config.YamlLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

final class FileWatch {
    private final Configuration configuration;
    private final YamlLoader yamlLoader;
    private final List<Entry> files;
    private final long delay;
    private final long period;

    FileWatch(Configuration configuration, List<File> loadedFiles, YamlLoader yamlLoader) {
        this.configuration = configuration;
        this.delay = configuration.getLong("config.watch.delay", 60L);
        this.period = configuration.getInt("config.watch.period", 10);
        this.yamlLoader = yamlLoader;
        this.files = this.initFiles(loadedFiles);
        if (this.files.isEmpty()) {
            Config.log.error("No files to watch?");
        } else {
            configuration.schedule(this.delay * 1000L, this.period * 1000L, this::check);
        }
    }

    public String toString() {
        return "Watch[period:" + this.period + " delay:" + this.delay + " files:" + this.files + "]";
    }

    private List<Entry> initFiles(List<File> loadedFiles) {
        ArrayList<Entry> entries = new ArrayList<Entry>(loadedFiles.size());
        for (File loadedFile : loadedFiles) {
            entries.add(new Entry(loadedFile));
        }
        return entries;
    }

    boolean changed() {
        for (Entry file : this.files) {
            if (!file.changed()) continue;
            return true;
        }
        return false;
    }

    void check() {
        for (Entry file : this.files) {
            if (!file.reload()) continue;
            Config.log.debug("reloading configuration from {}", (Object)file);
            if (file.isYaml()) {
                this.reloadYaml(file);
                continue;
            }
            this.reloadProps(file);
        }
    }

    private void reloadProps(Entry file) {
        Properties properties = new Properties();
        try (InputStream is = file.inputStream();){
            properties.load(is);
            this.put(properties);
        }
        catch (Exception e) {
            Config.log.error("Unexpected error reloading config file " + file, (Throwable)e);
        }
    }

    private void put(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String property = properties.getProperty(key);
            this.configuration.setProperty(key, property);
        }
    }

    private void reloadYaml(Entry file) {
        if (this.yamlLoader == null) {
            Config.log.error("Unexpected - no yamlLoader to reload config file " + file);
        } else {
            try (InputStream is = file.inputStream();){
                this.yamlLoader.load(is).forEach(this.configuration::setProperty);
            }
            catch (Exception e) {
                Config.log.error("Unexpected error reloading config file " + file, (Throwable)e);
            }
        }
    }

    private static class Entry {
        private final File file;
        private final boolean yaml;
        private long lastMod;

        Entry(File file) {
            this.file = file;
            this.lastMod = file.lastModified();
            this.yaml = this.isYaml(file.getName());
        }

        public String toString() {
            return this.file.toString();
        }

        boolean isYaml() {
            return this.yaml;
        }

        private boolean isYaml(String name) {
            String lowerName = name.toLowerCase();
            return lowerName.endsWith(".yaml") || lowerName.endsWith(".yml");
        }

        boolean reload() {
            if (!this.changed()) {
                return false;
            }
            this.lastMod = this.file.lastModified();
            return true;
        }

        boolean changed() {
            return this.file.lastModified() > this.lastMod;
        }

        InputStream inputStream() {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

