/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.config;

import io.avaje.config.Configuration;
import io.avaje.config.YamlLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileWatch {
    private static final Logger log = LoggerFactory.getLogger(FileWatch.class);
    private final Configuration configuration;
    private final YamlLoader yamlLoader;
    private final List<Entry> files;
    private final long delay;
    private final long period;

    FileWatch(Configuration configuration, List<File> loadedFiles, boolean withYaml) {
        this.configuration = configuration;
        this.files = this.initFiles(loadedFiles);
        this.delay = configuration.getLong("config.watch.delay", 60L);
        this.period = configuration.getInt("config.watch.period", 60);
        this.yamlLoader = withYaml ? new LoadYaml() : null;
        configuration.schedule(this.delay * 1000L, this.period * 1000L, this::check);
    }

    public String toString() {
        return "period:" + this.period + " delay:" + this.delay + " files:" + this.files;
    }

    private List<Entry> initFiles(List<File> loadedFiles) {
        ArrayList<Entry> entries = new ArrayList<Entry>(loadedFiles.size());
        for (File loadedFile : loadedFiles) {
            entries.add(new Entry(loadedFile));
        }
        return entries;
    }

    void check() {
        if (this.changed()) {
            this.reload();
        }
    }

    private boolean changed() {
        for (Entry file : this.files) {
            if (!file.changed()) continue;
            return true;
        }
        return false;
    }

    private void reload() {
        for (Entry file : this.files) {
            if (!file.changed()) continue;
            log.debug("reloading configuration from {}", (Object)file);
            if (file.isYaml()) {
                this.reloadYaml(file);
                continue;
            }
            this.reloadProps(file);
        }
    }

    private void reloadProps(Entry file) {
        Properties properties = new Properties();
        try (InputStream is = file.inputStream();){
            properties.load(is);
            this.put(properties);
        }
        catch (Exception e) {
            log.error("Unexpected error reloading config file " + file, (Throwable)e);
        }
    }

    private void put(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String property = properties.getProperty(key);
            this.configuration.setProperty(key, property);
        }
    }

    private void reloadYaml(Entry file) {
        if (this.yamlLoader == null) {
            log.error("Unexpected - no yamlLoader to reload config file " + file);
        } else {
            try (InputStream is = file.inputStream();){
                this.yamlLoader.load(is);
            }
            catch (Exception e) {
                log.error("Unexpected error reloading config file " + file, (Throwable)e);
            }
        }
    }

    private static class Entry {
        private final File file;
        private final long lastMod;
        private final boolean yaml;

        Entry(File file) {
            this.file = file;
            this.lastMod = file.lastModified();
            this.yaml = this.isYaml(file.getName());
        }

        public String toString() {
            return this.file.toString();
        }

        boolean isYaml() {
            return this.yaml;
        }

        private boolean isYaml(String name) {
            String lowerName = name.toLowerCase();
            return lowerName.endsWith(".yaml") || lowerName.endsWith(".yml");
        }

        boolean changed() {
            return this.file.lastModified() > this.lastMod;
        }

        InputStream inputStream() {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class LoadYaml
    extends YamlLoader {
        private LoadYaml() {
        }

        @Override
        void add(String key, String val) {
            FileWatch.this.configuration.setProperty(key, val);
        }
    }
}

