/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.api.configuration.supplier;

import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.agroal.api.configuration.supplier.AgroalConnectionFactoryConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalConnectionPoolConfigurationSupplier;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import io.agroal.api.security.NamePrincipal;
import io.agroal.api.security.SimplePassword;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class AgroalPropertiesReader
implements Supplier<AgroalDataSourceConfiguration> {
    public static final String IMPLEMENTATION = "implementation";
    public static final String JNDI_NAME = "jndiName";
    public static final String METRICS_ENABLED = "metricsEnabled";
    public static final String XA = "xa";
    public static final String MIN_SIZE = "minSize";
    public static final String MAX_SIZE = "maxSize";
    public static final String INITIAL_SIZE = "initialSize";
    public static final String PRE_FILL_MODE = "preFillMode";
    public static final String ACQUISITION_TIMEOUT = "acquisitionTimeout";
    public static final String ACQUISITION_TIMEOUT_MS = "acquisitionTimeout_ms";
    public static final String ACQUISITION_TIMEOUT_S = "acquisitionTimeout_s";
    public static final String ACQUISITION_TIMEOUT_M = "acquisitionTimeout_m";
    public static final String VALIDATION_TIMEOUT = "validationTimeout";
    public static final String VALIDATION_TIMEOUT_MS = "validationTimeout_ms";
    public static final String VALIDATION_TIMEOUT_S = "validationTimeout_s";
    public static final String VALIDATION_TIMEOUT_M = "validationTimeout_m";
    public static final String LEAK_TIMEOUT = "leakTimeout";
    public static final String LEAK_TIMEOUT_MS = "leakTimeout_ms";
    public static final String LEAK_TIMEOUT_S = "leakTimeout_s";
    public static final String LEAK_TIMEOUT_M = "leakTimeout_m";
    public static final String REAP_TIMEOUT = "reapTimeout";
    public static final String REAP_TIMEOUT_MS = "reapTimeout_ms";
    public static final String REAP_TIMEOUT_S = "reapTimeout_s";
    public static final String REAP_TIMEOUT_M = "reapTimeout_m";
    public static final String JDBC_URL = "jdbcUrl";
    public static final String AUTO_COMMIT = "autoCommit";
    public static final String INITIAL_SQL = "initialSQL";
    public static final String DRIVER_CLASS_NAME = "driverClassName";
    public static final String TRANSACTION_ISOLATION = "jdbcTransactionIsolation";
    public static final String PRINCIPAL = "principal";
    public static final String CREDENTIAL = "credential";
    public static final String JDBC_PROPERTIES = "jdbcProperties";
    private final String prefix;
    private final AgroalDataSourceConfigurationSupplier dataSourceSupplier;

    public AgroalPropertiesReader() {
        this("");
    }

    public AgroalPropertiesReader(String prefix) {
        this.prefix = prefix;
        this.dataSourceSupplier = new AgroalDataSourceConfigurationSupplier();
    }

    @Override
    public AgroalDataSourceConfiguration get() {
        return this.dataSourceSupplier.get();
    }

    public AgroalDataSourceConfigurationSupplier modify() {
        return this.dataSourceSupplier;
    }

    public AgroalPropertiesReader readProperties(Path path) throws IOException {
        return this.readProperties(path.toFile());
    }

    public AgroalPropertiesReader readProperties(String filename) throws IOException {
        return this.readProperties(new File(filename));
    }

    public AgroalPropertiesReader readProperties(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            Properties properties = new Properties();
            properties.load(inputStream);
            AgroalPropertiesReader agroalPropertiesReader = this.readProperties(properties);
            return agroalPropertiesReader;
        }
    }

    public AgroalPropertiesReader readProperties(Properties properties) {
        return this.readProperties((Map<String, String>)properties);
    }

    public AgroalPropertiesReader readProperties(Map<String, String> properties) {
        AgroalConnectionPoolConfigurationSupplier connectionPoolSupplier = new AgroalConnectionPoolConfigurationSupplier();
        AgroalConnectionFactoryConfigurationSupplier connectionFactorySupplier = new AgroalConnectionFactoryConfigurationSupplier();
        this.apply(this.dataSourceSupplier::dataSourceImplementation, AgroalDataSourceConfiguration.DataSourceImplementation::valueOf, properties, IMPLEMENTATION);
        this.apply(this.dataSourceSupplier::jndiName, Function.identity(), properties, JNDI_NAME);
        this.apply(this.dataSourceSupplier::metricsEnabled, Boolean::parseBoolean, properties, METRICS_ENABLED);
        this.apply(this.dataSourceSupplier::xa, Boolean::parseBoolean, properties, XA);
        this.apply(connectionPoolSupplier::minSize, Integer::parseInt, properties, MIN_SIZE);
        this.apply(connectionPoolSupplier::maxSize, Integer::parseInt, properties, MAX_SIZE);
        this.apply(connectionPoolSupplier::initialSize, Integer::parseInt, properties, INITIAL_SIZE);
        this.apply(connectionPoolSupplier::preFillMode, AgroalConnectionPoolConfiguration.PreFillMode::valueOf, properties, PRE_FILL_MODE);
        this.apply(connectionPoolSupplier::acquisitionTimeout, Duration::parse, properties, ACQUISITION_TIMEOUT);
        this.apply(connectionPoolSupplier::acquisitionTimeout, this::parseDurationMs, properties, ACQUISITION_TIMEOUT_MS);
        this.apply(connectionPoolSupplier::acquisitionTimeout, this::parseDurationS, properties, ACQUISITION_TIMEOUT_S);
        this.apply(connectionPoolSupplier::acquisitionTimeout, this::parseDurationM, properties, ACQUISITION_TIMEOUT_M);
        this.apply(connectionPoolSupplier::validationTimeout, Duration::parse, properties, VALIDATION_TIMEOUT);
        this.apply(connectionPoolSupplier::validationTimeout, this::parseDurationMs, properties, VALIDATION_TIMEOUT_MS);
        this.apply(connectionPoolSupplier::validationTimeout, this::parseDurationS, properties, VALIDATION_TIMEOUT_S);
        this.apply(connectionPoolSupplier::validationTimeout, this::parseDurationM, properties, VALIDATION_TIMEOUT_M);
        this.apply(connectionPoolSupplier::leakTimeout, Duration::parse, properties, LEAK_TIMEOUT);
        this.apply(connectionPoolSupplier::leakTimeout, this::parseDurationMs, properties, LEAK_TIMEOUT_MS);
        this.apply(connectionPoolSupplier::leakTimeout, this::parseDurationS, properties, LEAK_TIMEOUT_S);
        this.apply(connectionPoolSupplier::leakTimeout, this::parseDurationM, properties, LEAK_TIMEOUT_M);
        this.apply(connectionPoolSupplier::reapTimeout, Duration::parse, properties, REAP_TIMEOUT);
        this.apply(connectionPoolSupplier::reapTimeout, this::parseDurationMs, properties, REAP_TIMEOUT_MS);
        this.apply(connectionPoolSupplier::reapTimeout, this::parseDurationS, properties, REAP_TIMEOUT_S);
        this.apply(connectionPoolSupplier::reapTimeout, this::parseDurationM, properties, REAP_TIMEOUT_M);
        this.apply(connectionFactorySupplier::jdbcUrl, Function.identity(), properties, JDBC_URL);
        this.apply(connectionFactorySupplier::autoCommit, Boolean::parseBoolean, properties, AUTO_COMMIT);
        this.apply(connectionFactorySupplier::initialSql, Function.identity(), properties, INITIAL_SQL);
        this.apply(connectionFactorySupplier::driverClassName, Function.identity(), properties, DRIVER_CLASS_NAME);
        this.apply(connectionFactorySupplier::jdbcTransactionIsolation, AgroalConnectionFactoryConfiguration.TransactionIsolation::valueOf, properties, TRANSACTION_ISOLATION);
        this.apply(connectionFactorySupplier::principal, NamePrincipal::new, properties, PRINCIPAL);
        this.apply(connectionFactorySupplier::credential, SimplePassword::new, properties, CREDENTIAL);
        this.applyJdbcProperties(connectionFactorySupplier::jdbcProperty, properties, JDBC_PROPERTIES);
        this.dataSourceSupplier.connectionPoolConfiguration(connectionPoolSupplier.connectionFactoryConfiguration(connectionFactorySupplier));
        return this;
    }

    private <T> void apply(Consumer<T> consumer, Function<String, T> converter, Map<String, String> properties, String key) {
        String value = properties.get(this.prefix + key);
        if (value != null) {
            consumer.accept(converter.apply(value));
        }
    }

    private void applyJdbcProperties(BiConsumer<String, String> consumer, Map<String, String> properties, String key) {
        String propertiesArray = properties.get(this.prefix + key);
        if (propertiesArray != null && !propertiesArray.isEmpty()) {
            for (String property : propertiesArray.split(";")) {
                String[] keyValue = property.split("=");
                consumer.accept(keyValue[0], keyValue[1]);
            }
        }
    }

    private Duration parseDurationMs(String value) {
        return Duration.ofMillis(Long.parseLong(value));
    }

    private Duration parseDurationS(String value) {
        return Duration.ofSeconds(Long.parseLong(value));
    }

    private Duration parseDurationM(String value) {
        return Duration.ofMinutes(Long.parseLong(value));
    }
}

