/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.api.configuration.supplier;

import io.agroal.api.configuration.AgroalConnectionFactoryConfiguration;
import io.agroal.api.configuration.AgroalConnectionPoolConfiguration;
import io.agroal.api.configuration.ConnectionValidator;
import io.agroal.api.configuration.supplier.AgroalConnectionFactoryConfigurationSupplier;
import io.agroal.api.transaction.TransactionIntegration;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class AgroalConnectionPoolConfigurationSupplier
implements Supplier<AgroalConnectionPoolConfiguration> {
    private volatile boolean lock = false;
    private AgroalConnectionFactoryConfiguration connectionFactoryConfiguration = new AgroalConnectionFactoryConfigurationSupplier().get();
    @Deprecated
    private AgroalConnectionPoolConfiguration.PreFillMode preFillMode = AgroalConnectionPoolConfiguration.PreFillMode.NONE;
    private TransactionIntegration transactionIntegration = TransactionIntegration.none();
    private int initialSize = 0;
    private volatile int minSize = 0;
    private volatile int maxSize = Integer.MAX_VALUE;
    private ConnectionValidator connectionValidator = ConnectionValidator.emptyValidator();
    private Duration leakTimeout = Duration.ZERO;
    private Duration validationTimeout = Duration.ZERO;
    private Duration reapTimeout = Duration.ZERO;
    private volatile Duration acquisitionTimeout = Duration.ZERO;

    public AgroalConnectionPoolConfigurationSupplier() {
    }

    public AgroalConnectionPoolConfigurationSupplier(AgroalConnectionPoolConfiguration existingConfiguration) {
        this();
        if (existingConfiguration == null) {
            return;
        }
        this.connectionFactoryConfiguration = existingConfiguration.connectionFactoryConfiguration();
        this.preFillMode = existingConfiguration.preFillMode();
        this.transactionIntegration = existingConfiguration.transactionIntegration();
        this.initialSize = existingConfiguration.initialSize();
        this.minSize = existingConfiguration.minSize();
        this.maxSize = existingConfiguration.maxSize();
        this.connectionValidator = existingConfiguration.connectionValidator();
        this.leakTimeout = existingConfiguration.leakTimeout();
        this.validationTimeout = existingConfiguration.validationTimeout();
        this.reapTimeout = existingConfiguration.reapTimeout();
        this.acquisitionTimeout = existingConfiguration.acquisitionTimeout();
    }

    private AgroalConnectionPoolConfigurationSupplier applySetting(Consumer<AgroalConnectionPoolConfigurationSupplier> consumer) {
        if (this.lock) {
            throw new IllegalStateException("Attempt to modify an immutable configuration");
        }
        consumer.accept(this);
        return this;
    }

    private AgroalConnectionPoolConfigurationSupplier connectionFactoryConfiguration(AgroalConnectionFactoryConfiguration configuration) {
        return this.applySetting(c -> {
            c.connectionFactoryConfiguration = configuration;
        });
    }

    public AgroalConnectionPoolConfigurationSupplier connectionFactoryConfiguration(Supplier<AgroalConnectionFactoryConfiguration> supplier) {
        return this.connectionFactoryConfiguration(supplier.get());
    }

    public AgroalConnectionPoolConfigurationSupplier connectionFactoryConfiguration(Function<AgroalConnectionFactoryConfigurationSupplier, AgroalConnectionFactoryConfigurationSupplier> function) {
        return this.connectionFactoryConfiguration(function.apply(new AgroalConnectionFactoryConfigurationSupplier(this.connectionFactoryConfiguration)));
    }

    public AgroalConnectionPoolConfigurationSupplier transactionIntegration(TransactionIntegration integration) {
        return this.applySetting(c -> {
            c.transactionIntegration = integration;
        });
    }

    @Deprecated
    public AgroalConnectionPoolConfigurationSupplier preFillMode(AgroalConnectionPoolConfiguration.PreFillMode mode) {
        return this.applySetting(c -> {
            c.preFillMode = mode;
        });
    }

    public AgroalConnectionPoolConfigurationSupplier initialSize(int size) {
        return this.applySetting(c -> {
            c.initialSize = size;
        });
    }

    public AgroalConnectionPoolConfigurationSupplier minSize(int size) {
        return this.applySetting(c -> {
            c.minSize = size;
        });
    }

    public AgroalConnectionPoolConfigurationSupplier maxSize(int size) {
        return this.applySetting(c -> {
            c.maxSize = size;
        });
    }

    public AgroalConnectionPoolConfigurationSupplier connectionValidator(ConnectionValidator validator) {
        return this.applySetting(c -> {
            c.connectionValidator = validator;
        });
    }

    public AgroalConnectionPoolConfigurationSupplier acquisitionTimeout(Duration timeout) {
        return this.applySetting(c -> {
            c.acquisitionTimeout = timeout;
        });
    }

    public AgroalConnectionPoolConfigurationSupplier leakTimeout(Duration timeout) {
        return this.applySetting(c -> {
            c.leakTimeout = timeout;
        });
    }

    public AgroalConnectionPoolConfigurationSupplier validationTimeout(Duration timeout) {
        return this.applySetting(c -> {
            c.validationTimeout = timeout;
        });
    }

    public AgroalConnectionPoolConfigurationSupplier reapTimeout(Duration timeout) {
        return this.applySetting(c -> {
            c.reapTimeout = timeout;
        });
    }

    private void validate() {
        if (this.minSize < 0) {
            throw new IllegalArgumentException("Invalid min size: smaller than 0");
        }
        if (this.maxSize <= 0) {
            throw new IllegalArgumentException("A Positive max size is required");
        }
        if (this.minSize > this.maxSize) {
            throw new IllegalArgumentException("Invalid min size: greater than max size");
        }
        if (this.initialSize < this.minSize || this.initialSize > this.maxSize) {
            throw new IllegalArgumentException("Invalid value for initial size. Must be between min and max.");
        }
        if (this.maxSize == Integer.MAX_VALUE && AgroalConnectionPoolConfiguration.PreFillMode.MAX.equals((Object)this.preFillMode)) {
            throw new IllegalArgumentException("Invalid pre-fill mode MAX without specifying max size");
        }
        if (this.connectionFactoryConfiguration == null) {
            throw new IllegalArgumentException("Connection factory configuration not defined");
        }
    }

    @Override
    public AgroalConnectionPoolConfiguration get() {
        this.validate();
        this.lock = true;
        return new AgroalConnectionPoolConfiguration(){

            @Override
            public AgroalConnectionFactoryConfiguration connectionFactoryConfiguration() {
                return AgroalConnectionPoolConfigurationSupplier.this.connectionFactoryConfiguration;
            }

            @Override
            public TransactionIntegration transactionIntegration() {
                return AgroalConnectionPoolConfigurationSupplier.this.transactionIntegration;
            }

            @Override
            public AgroalConnectionPoolConfiguration.PreFillMode preFillMode() {
                return AgroalConnectionPoolConfigurationSupplier.this.preFillMode;
            }

            @Override
            public int initialSize() {
                return AgroalConnectionPoolConfigurationSupplier.this.initialSize;
            }

            @Override
            public int minSize() {
                return AgroalConnectionPoolConfigurationSupplier.this.minSize;
            }

            @Override
            public void setMinSize(int size) {
                AgroalConnectionPoolConfigurationSupplier.this.minSize = size;
            }

            @Override
            public int maxSize() {
                return AgroalConnectionPoolConfigurationSupplier.this.maxSize;
            }

            @Override
            public void setMaxSize(int size) {
                AgroalConnectionPoolConfigurationSupplier.this.maxSize = size;
            }

            @Override
            public Duration acquisitionTimeout() {
                return AgroalConnectionPoolConfigurationSupplier.this.acquisitionTimeout;
            }

            @Override
            public void setAcquisitionTimeout(Duration timeout) {
                AgroalConnectionPoolConfigurationSupplier.this.acquisitionTimeout = timeout;
            }

            @Override
            public ConnectionValidator connectionValidator() {
                return AgroalConnectionPoolConfigurationSupplier.this.connectionValidator;
            }

            @Override
            public Duration leakTimeout() {
                return AgroalConnectionPoolConfigurationSupplier.this.leakTimeout;
            }

            @Override
            public Duration validationTimeout() {
                return AgroalConnectionPoolConfigurationSupplier.this.validationTimeout;
            }

            @Override
            public Duration reapTimeout() {
                return AgroalConnectionPoolConfigurationSupplier.this.reapTimeout;
            }
        };
    }
}

