/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.validation;

import info.archinnov.achilles.exception.AchillesBeanMappingException;
import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.exception.AchillesInvalidTableException;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class Validator {
    public static void validateNotBlank(String arg, String message, Object ... args) {
        if (StringUtils.isBlank((CharSequence)arg)) {
            throw new AchillesException(String.format(message, args));
        }
    }

    public static void validateNotNull(Object arg, String message, Object ... args) {
        if (arg == null) {
            throw new AchillesException(String.format(message, args));
        }
    }

    public static void validateBeanMappingNotNull(Object arg, String message, Object ... args) {
        if (arg == null) {
            throw new AchillesBeanMappingException(String.format(message, args));
        }
    }

    public static void validateNotEmpty(Object[] arg, String message, Object ... args) {
        if (ArrayUtils.isEmpty((Object[])arg)) {
            throw new AchillesException(String.format(message, args));
        }
    }

    public static void validateNotEmpty(Collection<?> arg, String message, Object ... args) {
        if (CollectionUtils.isEmpty(arg)) {
            throw new AchillesException(String.format(message, args));
        }
    }

    public static void validateNotEmpty(Map<?, ?> arg, String message, Object ... args) {
        if (MapUtils.isEmpty(arg)) {
            throw new AchillesException(String.format(message, args));
        }
    }

    public static void validateEmpty(Collection<?> arg, String message, Object ... args) {
        if (CollectionUtils.isNotEmpty(arg)) {
            throw new AchillesException(String.format(message, args));
        }
    }

    public static void validateSize(Map<?, ?> arg, int size, String message, Object ... args) {
        Validator.validateNotEmpty(arg, "The map '%s' should not be empty", args);
        if (arg.size() != size) {
            throw new AchillesException(String.format(message, args));
        }
    }

    public static void validateComparable(Class<?> type, String message, Object ... args) {
        if (!Comparable.class.isAssignableFrom(type)) {
            throw new AchillesException(String.format(message, args));
        }
    }

    public static void validateRegExp(String arg, String regexp, String label) {
        Validator.validateNotBlank(arg, "The text value '%s' should not be blank", label);
        if (!Pattern.matches(regexp, arg)) {
            throw new AchillesException(String.format("The property '%s' should match the pattern '%s'", label, regexp));
        }
    }

    public static void validateInstantiable(Class<?> arg) {
        Validator.validateNotNull(arg, "The class should not be null", new Object[0]);
        String canonicalName = arg.getCanonicalName();
        try {
            arg.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new AchillesBeanMappingException(String.format("Cannot instantiate the class '%s'. Please ensure the class is not an abstract class, an interface, an array class, a primitive type, or void and have a nullary (default) constructor and is declared public", canonicalName));
        }
    }

    public static <T> void validateInstanceOf(Object entity, Class<T> targetClass, String message, Object ... args) {
        Validator.validateNotNull(entity, "Entity '%s' should not be null", entity);
        if (!targetClass.isInstance(entity)) {
            throw new AchillesException(String.format(message, args));
        }
    }

    public static void validateTrue(boolean condition, String message, Object ... args) {
        if (!condition) {
            throw new AchillesException(String.format(message, args));
        }
    }

    public static void validateBeanMappingTrue(boolean condition, String message, Object ... args) {
        if (!condition) {
            throw new AchillesBeanMappingException(String.format(message, args));
        }
    }

    public static void validateTableTrue(boolean condition, String message, Object ... args) {
        if (!condition) {
            throw new AchillesInvalidTableException(String.format(message, args));
        }
    }

    public static void validateFalse(boolean condition, String message, Object ... args) {
        if (condition) {
            throw new AchillesException(String.format(message, args));
        }
    }

    public static void validateBeanMappingFalse(boolean condition, String message, Object ... args) {
        if (condition) {
            throw new AchillesBeanMappingException(String.format(message, args));
        }
    }

    public static void validateTableFalse(boolean condition, String message, Object ... args) {
        if (condition) {
            throw new AchillesInvalidTableException(String.format(message, args));
        }
    }
}

