/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD})
@Documented
public @interface SASI {
    public String name() default "";

    public IndexMode indexMode() default IndexMode.PREFIX;

    public boolean analyzed() default false;

    public Analyzer analyzerClass() default Analyzer.NO_OP_ANALYZER;

    public int maxCompactionFlushMemoryInMb() default 1024;

    public Normalization normalization() default Normalization.NONE;

    public String locale() default "en";

    public boolean enableStemming() default false;

    public boolean skipStopWords() default false;

    public static enum Normalization {
        LOWERCASE{

            @Override
            public String forStandardAnalyzer() {
                return "tokenization_normalize_lowercase";
            }

            @Override
            public String forNonTokenizingAnalyzer() {
                return "normalize_lowercase";
            }
        }
        ,
        UPPERCASE{

            @Override
            public String forStandardAnalyzer() {
                return "tokenization_normalize_uppercase";
            }

            @Override
            public String forNonTokenizingAnalyzer() {
                return "normalize_uppercase";
            }
        }
        ,
        NONE{

            @Override
            public String forStandardAnalyzer() {
                return "";
            }

            @Override
            public String forNonTokenizingAnalyzer() {
                return "";
            }
        };


        public abstract String forStandardAnalyzer();

        public abstract String forNonTokenizingAnalyzer();
    }

    public static enum Analyzer {
        NO_OP_ANALYZER("org.apache.cassandra.index.sasi.analyzer.NoOpAnalyzer"),
        NON_TOKENIZING_ANALYZER("org.apache.cassandra.index.sasi.analyzer.NonTokenizingAnalyzer"),
        STANDARD_ANALYZER("org.apache.cassandra.index.sasi.analyzer.StandardAnalyzer");

        private String analyzerClass;

        private Analyzer(String analyzerClass) {
            this.analyzerClass = analyzerClass;
        }

        public String analyzerClass() {
            return this.analyzerClass;
        }
    }

    public static enum IndexMode {
        PREFIX,
        CONTAINS,
        SPARSE;

    }
}

