/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.types;

import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.util.concurrent.Uninterruptibles;
import info.archinnov.achilles.internals.dsl.AsyncAware;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.statements.StatementWrapper;
import info.archinnov.achilles.type.interceptor.Event;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class EntityIteratorWrapper<ENTITY>
implements Iterator<ENTITY>,
AsyncAware {
    private final Iterator<Row> delegate;
    private final AbstractEntityProperty<ENTITY> meta;
    private final StatementWrapper statementWrapper;
    private final CassandraOptions options;
    private ExecutionInfo executionInfo;

    public EntityIteratorWrapper(CompletableFuture<ResultSet> futureRS, AbstractEntityProperty<ENTITY> meta, StatementWrapper statementWrapper, CassandraOptions cassandraOptions) {
        this.meta = meta;
        this.statementWrapper = statementWrapper;
        this.options = cassandraOptions;
        try {
            this.delegate = (Iterator)Uninterruptibles.getUninterruptibly((Future)((Object)((CompletableFuture)((CompletableFuture)((CompletableFuture)futureRS.thenApply(cassandraOptions::resultSetAsyncListener)).thenApply(statementWrapper::logTrace)).thenApply(rs -> {
                this.executionInfo = rs.getExecutionInfo();
                return rs;
            })).thenApply(rs -> rs.iterator())));
        }
        catch (ExecutionException e) {
            throw this.extractCauseFromExecutionException(e);
        }
    }

    public ExecutionInfo getExecutionInfo() {
        return this.executionInfo;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public ENTITY next() {
        if (this.delegate.hasNext()) {
            Row row = this.delegate.next();
            this.statementWrapper.logReturnedRow(row);
            this.options.rowAsyncListener(row);
            ENTITY instance = this.meta.createEntityFrom(row);
            this.meta.triggerInterceptorsForEvent(Event.POST_LOAD, instance);
            return instance;
        }
        return null;
    }
}

