/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.strategy.naming;

import info.archinnov.achilles.annotations.Strategy;
import info.archinnov.achilles.internals.strategy.naming.CaseSensitiveNaming;
import info.archinnov.achilles.internals.strategy.naming.LowerCaseNaming;
import info.archinnov.achilles.internals.strategy.naming.SnakeCaseNaming;
import info.archinnov.achilles.type.strategy.NamingStrategy;
import java.util.Arrays;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;

public interface InternalNamingStrategy {
    public static InternalNamingStrategy inferNamingStrategy(Optional<Strategy> strategy, InternalNamingStrategy defaultStrategy) {
        return strategy.map(x -> InternalNamingStrategy.getNamingStrategy(x.naming())).orElse(defaultStrategy);
    }

    public static InternalNamingStrategy getNamingStrategy(NamingStrategy namingStrategy) {
        switch (namingStrategy) {
            case SNAKE_CASE: {
                return new SnakeCaseNaming();
            }
            case CASE_SENSITIVE: {
                return new CaseSensitiveNaming();
            }
        }
        return new LowerCaseNaming();
    }

    public String apply(String var1);

    public String FQCN();

    default public String toCaseSensitive(String name) {
        if (name.equals(name.toLowerCase())) {
            return name;
        }
        return "\"" + name + "\"";
    }

    default public String toSnakeCase(String name) {
        String[] tokens = StringUtils.splitByCharacterTypeCamelCase((String)name);
        StringJoiner joiner = new StringJoiner("_");
        Arrays.asList(tokens).stream().filter(x -> x != null).map(x -> x.toLowerCase()).forEach(joiner::add);
        return joiner.toString().replaceAll("_+", "_");
    }
}

