/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.statements;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.SettableData;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.statements.BoundStatementWrapper;
import info.archinnov.achilles.internals.statements.BoundValueInfo;
import info.archinnov.achilles.internals.statements.OperationType;
import info.archinnov.achilles.internals.statements.StatementWrapper;
import info.archinnov.achilles.type.strategy.InsertStrategy;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundValuesWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoundValuesWrapper.class);
    public final List<BoundValueInfo> boundValuesInfo;
    public final AbstractEntityProperty<?> meta;

    public BoundValuesWrapper(AbstractEntityProperty<?> meta, List<BoundValueInfo> boundValuesInfo) {
        this.meta = meta;
        this.boundValuesInfo = boundValuesInfo;
    }

    public StatementWrapper bindWithInsertStrategy(PreparedStatement ps, InsertStrategy insertStrategy) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Bind values %s to query %s with insert strategy %s", this.boundValuesInfo, ps.getQueryString(), insertStrategy.name()));
        }
        if (insertStrategy == InsertStrategy.ALL_FIELDS) {
            return new BoundStatementWrapper(OperationType.INSERT, this.meta, ps, this.boundValuesInfo.stream().map(x -> x.boundValue).toArray(), this.boundValuesInfo.stream().map(x -> x.encodedValue).toArray());
        }
        BoundStatement bs = ps.bind();
        this.boundValuesInfo.stream().filter(x -> x.encodedValue != null).forEach(x -> x.setter.accept(x.encodedValue, (SettableData)bs));
        return new BoundStatementWrapper(OperationType.INSERT, this.meta, bs, this.boundValuesInfo.stream().map(x -> x.boundValue).toArray(), this.boundValuesInfo.stream().map(x -> x.encodedValue).toArray());
    }

    public StatementWrapper bindForUpdate(PreparedStatement ps) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Bind values %s to query %s for UPDATE", this.boundValuesInfo, ps.getQueryString()));
        }
        BoundStatement bs = ps.bind();
        this.boundValuesInfo.stream().filter(x -> x.encodedValue != null).forEach(x -> x.setter.accept(x.encodedValue, (SettableData)bs));
        return new BoundStatementWrapper(OperationType.UPDATE, this.meta, bs, this.boundValuesInfo.stream().map(x -> x.boundValue).toArray(), this.boundValuesInfo.stream().map(x -> x.encodedValue).toArray());
    }
}

