/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.statements;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.statements.OperationType;
import info.archinnov.achilles.internals.statements.StatementWrapper;
import info.archinnov.achilles.internals.types.ResultSetWrapper;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundStatementWrapper
implements StatementWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoundStatementWrapper.class);
    private final OperationType operationType;
    private final AbstractEntityProperty<?> meta;
    private final Object[] boundValues;
    private final Object[] encodedBoundValues;
    private final Logger actualLogger;
    private BoundStatement bs;
    private UUID queryId;

    public BoundStatementWrapper(OperationType operationType, AbstractEntityProperty<?> meta, PreparedStatement ps, Object[] boundValues, Object[] encodedBoundValues) {
        this(operationType, meta, ps.bind(encodedBoundValues), boundValues, encodedBoundValues);
    }

    public BoundStatementWrapper(OperationType operationType, AbstractEntityProperty<?> meta, BoundStatement bs, Object[] encodedBoundValues) {
        this(operationType, meta, bs, new Object[0], encodedBoundValues);
    }

    public BoundStatementWrapper(OperationType operationType, AbstractEntityProperty<?> meta, BoundStatement bs, Object[] boundValues, Object[] encodedBoundValues) {
        this.operationType = operationType;
        this.meta = meta;
        this.bs = bs;
        this.boundValues = boundValues;
        this.encodedBoundValues = encodedBoundValues;
        this.actualLogger = meta.entityLogger.isDebugEnabled() ? meta.entityLogger : DML_LOGGER;
    }

    @Override
    public Object[] getBoundValues() {
        return this.boundValues;
    }

    @Override
    public BoundStatement getBoundStatement() {
        return this.bs;
    }

    @Override
    public void applyOptions(CassandraOptions cassandraOptions) {
        cassandraOptions.applyOptions(this.operationType, this.meta, (Statement)this.bs);
    }

    @Override
    public void logDML() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Maybe log DML query %s", this.bs.preparedStatement().getQueryString()));
        }
        this.queryId = UUID.randomUUID();
        if (this.actualLogger.isDebugEnabled()) {
            this.writeDMLStatementLog(this.actualLogger, this.queryId, this.bs.preparedStatement().getQueryString(), this.bs.getConsistencyLevel(), this.boundValues, this.encodedBoundValues);
        }
    }

    @Override
    public ResultSet logReturnResults(ResultSet originalResultSet, int maxDisplayedRows) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Log returned results for query %s", this.bs.preparedStatement().getQueryString()));
        }
        if (this.actualLogger.isDebugEnabled()) {
            ResultSetWrapper wrapper = new ResultSetWrapper(originalResultSet);
            this.logReturnedResultsInternal(this.actualLogger, this.queryId, wrapper, maxDisplayedRows);
            return wrapper;
        }
        return originalResultSet;
    }

    @Override
    public Row logReturnedRow(Row row) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Log returned row for query %s", this.bs.preparedStatement().getQueryString()));
        }
        if (this.actualLogger.isDebugEnabled()) {
            this.logReturnedRowInternal(this.actualLogger, this.queryId, row);
        }
        return row;
    }

    @Override
    public ResultSet logTrace(ResultSet resultSet) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Maybe display tracing for query %s", this.bs.preparedStatement().getQueryString()));
        }
        this.tracingInternal(this.actualLogger, this.queryId, resultSet);
        return resultSet;
    }
}

