/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.schema;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.metamodel.AbstractProperty;
import info.archinnov.achilles.internals.metamodel.AbstractUDTClassProperty;
import info.archinnov.achilles.internals.metamodel.AbstractViewProperty;
import info.archinnov.achilles.internals.metamodel.columns.ClusteringColumnInfo;
import info.archinnov.achilles.internals.metamodel.index.IndexInfo;
import info.archinnov.achilles.internals.metamodel.index.IndexType;
import info.archinnov.achilles.internals.schema.SchemaContext;
import info.archinnov.achilles.internals.types.OverridingOptional;
import info.archinnov.achilles.type.tuples.Tuple2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaCreator {
    public static final Logger ACHILLES_DML_LOGGER = LoggerFactory.getLogger((String)"ACHILLES_DDL_SCRIPT");
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaCreator.class);

    public static List<String> generateTable_And_Indices(SchemaContext context, AbstractEntityProperty<?> entityProperty) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Generating table, udt type and indices for entity of type %s", entityProperty.entityClass.getCanonicalName()));
        }
        ArrayList<String> schemas = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        Optional<Object> keyspace = Optional.ofNullable(context.keyspace.orElse(entityProperty.staticKeyspace.orElse(null)));
        String tableName = entityProperty.getTableOrViewName();
        Optional<String> staticKeyspace = entityProperty.getKeyspace();
        Optional<Optional<Object>> overridenKeyspace = OverridingOptional.from(staticKeyspace).andThen((Optional<String>)keyspace).getOptional();
        Create table = overridenKeyspace.isPresent() ? (Create)SchemaBuilder.createTable((String)((String)((Object)overridenKeyspace.get())), (String)tableName).ifNotExists() : (Create)SchemaBuilder.createTable((String)tableName).ifNotExists();
        for (AbstractProperty x2 : entityProperty.partitionKeys) {
            table.addPartitionKey(x2.fieldInfo.quotedCqlColumn, x2.buildType(Optional.empty()));
        }
        for (AbstractProperty x2 : entityProperty.clusteringColumns) {
            table.addClusteringColumn(x2.fieldInfo.quotedCqlColumn, x2.buildType(Optional.empty()));
        }
        for (AbstractProperty x2 : entityProperty.staticColumns) {
            table.addStaticColumn(x2.fieldInfo.quotedCqlColumn, x2.buildType(Optional.empty()));
        }
        for (AbstractProperty x2 : entityProperty.normalColumns) {
            DataType dataType = x2.buildType(Optional.empty());
            if (!x2.fieldInfo.columnInfo.frozen && dataType instanceof UserType) {
                String udtLiteral = dataType.toString().replaceAll("frozen<(.+)>", "$1");
                table.addUDTColumn(x2.fieldInfo.quotedCqlColumn, SchemaBuilder.udtLiteral((String)udtLiteral));
                continue;
            }
            table.addColumn(x2.fieldInfo.quotedCqlColumn, dataType);
        }
        for (AbstractProperty x2 : entityProperty.counterColumns) {
            table.addColumn(x2.fieldInfo.quotedCqlColumn, x2.buildType(Optional.empty()));
        }
        Create.Options options = table.withOptions();
        if (entityProperty.clusteringColumns.size() > 0 || entityProperty.staticTTL.isPresent()) {
            entityProperty.clusteringColumns.stream().map(x -> Tuple2.of((Object)x.fieldInfo.quotedCqlColumn, (Object)((ClusteringColumnInfo)x.fieldInfo.columnInfo))).forEach(x -> options.clusteringOrder((String)x._1(), ((ClusteringColumnInfo)x._2()).direction));
            if (entityProperty.staticTTL.isPresent()) {
                options.defaultTimeToLive(Integer.valueOf(entityProperty.staticTTL.get()));
            }
            builder.append(options.getQueryString().replaceFirst("\t+", "")).append(";");
        } else {
            builder.append(table.getQueryString().replaceFirst("\t+", "")).append(";");
        }
        schemas.add(builder.toString());
        if (context.createIndex) {
            entityProperty.allColumns.stream().filter(x -> x.fieldInfo.indexInfo.type != IndexType.NONE).map(x -> Tuple2.of((Object)x.fieldInfo.quotedCqlColumn, (Object)x.fieldInfo.indexInfo)).forEach(tuple -> schemas.add(((IndexInfo)tuple._2()).generate(keyspace, tableName, (String)tuple._1())));
        }
        return schemas;
    }

    public static List<String> generateView(SchemaContext context, AbstractViewProperty<?> viewProperty) {
        String baseTableName;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Generating materialized view for entity of type %s", viewProperty.entityClass.getCanonicalName()));
        }
        Optional<Object> keyspace = Optional.ofNullable(context.keyspace.orElse(viewProperty.staticKeyspace.orElse(null)));
        StringBuilder viewScript = new StringBuilder();
        String viewName = viewProperty.getTableOrViewName();
        Optional<String> staticKeyspace = viewProperty.getKeyspace();
        Optional<Optional<Object>> overridenKeyspace = OverridingOptional.from(staticKeyspace).andThen((Optional<String>)keyspace).getOptional();
        AbstractEntityProperty<?> baseClassProperty = viewProperty.getBaseClassProperty();
        if (overridenKeyspace.isPresent()) {
            viewScript.append("CREATE MATERIALIZED VIEW IF NOT EXISTS ").append((String)((Object)overridenKeyspace.get())).append(".").append(viewName).append("\n").append("AS SELECT ");
            baseTableName = (String)((Object)overridenKeyspace.get()) + "." + baseClassProperty.getTableOrViewName();
        } else {
            viewScript.append("CREATE MATERIALIZED VIEW IF NOT EXISTS ").append(viewName).append("\n").append("AS SELECT ");
            baseTableName = baseClassProperty.getTableOrViewName();
        }
        StringJoiner columns = new StringJoiner(",");
        viewProperty.allColumns.forEach(x -> columns.add(x.fieldInfo.quotedCqlColumn));
        viewScript.append(columns.toString()).append("\n");
        viewScript.append("FROM ").append(baseTableName).append("\n");
        ArrayList viewPksProperty = new ArrayList(viewProperty.partitionKeys);
        viewPksProperty.addAll(viewProperty.clusteringColumns);
        StringJoiner whereClause = new StringJoiner(" AND ");
        viewPksProperty.forEach(x -> whereClause.add(x.fieldInfo.quotedCqlColumn + " IS NOT NULL"));
        viewScript.append("WHERE ").append(whereClause).append("\n");
        StringJoiner partitionKeys = new StringJoiner(",", "(", ")");
        StringJoiner clusteringColumns = new StringJoiner(",");
        viewProperty.partitionKeys.forEach(x -> partitionKeys.add(x.fieldInfo.quotedCqlColumn));
        viewProperty.clusteringColumns.forEach(x -> clusteringColumns.add(x.fieldInfo.quotedCqlColumn));
        viewScript.append("PRIMARY KEY").append("(").append(partitionKeys).append(",").append(clusteringColumns).append(")");
        if (viewProperty.clusteringColumns.size() > 0) {
            StringJoiner clusteringOrder = new StringJoiner(",");
            viewProperty.clusteringColumns.stream().forEach(x -> clusteringOrder.add(x.fieldInfo.quotedCqlColumn + " " + ((ClusteringColumnInfo)x.fieldInfo.columnInfo).clusteringOrder.name()));
            viewScript.append("\n").append("WITH CLUSTERING ORDER BY").append("(").append(clusteringOrder).append(")");
        }
        return Arrays.asList(viewScript.append(";").toString());
    }

    public static void generateSchemaAtRuntime(Session session, AbstractEntityProperty<?> entityProperty) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Generating schema for entity of type %s", entityProperty.entityClass.getCanonicalName()));
        }
        String keyspace = entityProperty.getKeyspace().orElseGet(() -> ((Session)session).getLoggedKeyspace());
        SchemaContext schemaContext = new SchemaContext(keyspace, true, true);
        List<String> schemas = entityProperty.isTable() ? SchemaCreator.generateTable_And_Indices(schemaContext, entityProperty) : SchemaCreator.generateView(schemaContext, (AbstractViewProperty)entityProperty);
        for (String schema : schemas) {
            if (ACHILLES_DML_LOGGER.isDebugEnabled()) {
                ACHILLES_DML_LOGGER.debug(schema + "\n");
            }
            ResultSet resultSet = session.execute(schema);
            resultSet.getExecutionInfo().isSchemaInAgreement();
        }
    }

    public static void generateUDTAtRuntime(Session session, AbstractUDTClassProperty<?> udtClassProperty) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Generating schema for udt of type %s", udtClassProperty.udtClass.getCanonicalName()));
        }
        udtClassProperty.componentsProperty.stream().flatMap(x -> x.getUDTClassProperties().stream()).forEach(x -> SchemaCreator.generateUDTAtRuntime(session, x));
        String udtKeyspace = udtClassProperty.staticKeyspace.orElseGet(() -> ((Session)session).getLoggedKeyspace());
        SchemaContext schemaContext = new SchemaContext(udtKeyspace, true, true);
        String udtSchema = udtClassProperty.generateSchema(schemaContext);
        if (ACHILLES_DML_LOGGER.isDebugEnabled()) {
            ACHILLES_DML_LOGGER.debug(udtSchema + "\n");
        }
        ResultSet resultSet = session.execute(udtSchema);
        resultSet.getExecutionInfo().isSchemaInAgreement();
    }
}

