/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.runtime;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.internals.cache.CacheKey;
import info.archinnov.achilles.internals.cache.StatementsCache;
import info.archinnov.achilles.internals.context.ConfigurationContext;
import info.archinnov.achilles.internals.factory.TupleTypeFactory;
import info.archinnov.achilles.internals.factory.UserTypeFactory;
import info.archinnov.achilles.internals.futures.FutureUtils;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.statements.StatementWrapper;
import info.archinnov.achilles.type.SchemaNameProvider;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeEngine.class);
    public final StatementsCache cache;
    public final ConfigurationContext configContext;
    public final Session session;
    public final String currentKeyspace;
    public final ExecutorService executor;
    public TupleTypeFactory tupleTypeFactory;
    public UserTypeFactory userTypeFactory;

    public RuntimeEngine(ConfigurationContext configContext) {
        this.configContext = configContext;
        this.session = configContext.getSession();
        this.cache = configContext.getStatementsCache();
        this.currentKeyspace = configContext.getCurrentKeyspace().orElseGet(() -> ((Session)this.session).getLoggedKeyspace());
        this.executor = configContext.getExecutorService();
    }

    public PreparedStatement getStaticCache(CacheKey cacheKey) {
        return this.cache.getStaticCache(cacheKey);
    }

    public CompletableFuture<ResultSet> execute(StatementWrapper wrapper) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Executing statement %s", wrapper.getBoundStatement().preparedStatement().getQueryString()));
        }
        wrapper.logDML();
        return FutureUtils.toCompletableFuture((ListenableFuture)this.session.executeAsync((Statement)wrapper.getBoundStatement()), (ExecutorService)this.executor);
    }

    public CompletableFuture<ResultSet> execute(BoundStatement boundStatement) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Executing bound statement %s", boundStatement.preparedStatement().getQueryString()));
        }
        return FutureUtils.toCompletableFuture((ListenableFuture)this.session.executeAsync((Statement)boundStatement), (ExecutorService)this.executor);
    }

    public CompletableFuture<ResultSet> execute(BatchStatement batchStatement) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Executing batch statement : %s", batchStatement.getStatements().stream().map(Object::toString).reduce("", (x, y) -> x + y)));
        }
        return FutureUtils.toCompletableFuture((ListenableFuture)this.session.executeAsync((Statement)batchStatement), (ExecutorService)this.executor);
    }

    public PreparedStatement prepareDynamicQuery(RegularStatement statement) {
        return this.prepareDynamicQuery(statement.getQueryString());
    }

    public PreparedStatement prepareDynamicQuery(String queryString) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Preparing dynamic query %s", queryString));
        }
        return this.cache.getDynamicCache(queryString, this.session);
    }

    public Optional<PreparedStatement> maybePrepareIfDifferentSchemaNameFromCache(AbstractEntityProperty<?> entityProperty, PreparedStatement psFromCache, Optional<SchemaNameProvider> schemaNameProvider, Supplier<RegularStatement> lambda) {
        if (schemaNameProvider.isPresent()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Preparing statement %s using optional schema name provider %s", psFromCache.getQueryString(), schemaNameProvider));
            }
            SchemaNameProvider provider = schemaNameProvider.get();
            String tableNameWithKeyspace = provider.keyspaceFor(entityProperty.entityClass) + "." + provider.tableNameFor(entityProperty.entityClass);
            if (!psFromCache.getQueryString().toLowerCase().contains("from " + tableNameWithKeyspace)) {
                return Optional.of(this.prepareDynamicQuery(lambda.get()));
            }
        }
        return Optional.empty();
    }

    public Cluster getCluster() {
        return this.session.getCluster();
    }
}

