/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.runtime;

import com.datastax.driver.core.SettableData;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.metamodel.AbstractProperty;
import info.archinnov.achilles.internals.options.CassandraOptions;
import info.archinnov.achilles.internals.statements.BoundValueInfo;
import info.archinnov.achilles.internals.statements.BoundValuesWrapper;
import info.archinnov.achilles.internals.types.OverridingOptional;
import info.archinnov.achilles.type.tuples.Tuple2;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanValueExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanValueExtractor.class);

    public static <T> BoundValuesWrapper extractAllValues(T instance, AbstractEntityProperty<T> entityProperty, CassandraOptions cassandraOptions) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Extract values from entity %s of type %s", instance, entityProperty.entityClass.getCanonicalName()));
        }
        ArrayList<BoundValueInfo> boundValues = new ArrayList<BoundValueInfo>();
        List partitionKeys = entityProperty.partitionKeys.stream().map(x -> {
            AbstractProperty x1 = x;
            BiConsumer<Object, SettableData> lambda = x1::encodeToSettable;
            return BoundValueInfo.of(lambda, x.getFieldValue(instance), x.encodeField(instance, Optional.ofNullable(cassandraOptions)));
        }).collect(Collectors.toList());
        boundValues.addAll(partitionKeys);
        boundValues.addAll(entityProperty.staticColumns.stream().map(x -> {
            AbstractProperty x1 = x;
            return BoundValueInfo.of(x1::encodeToSettable, x.getFieldValue(instance), x.encodeField(instance, Optional.ofNullable(cassandraOptions)));
        }).collect(Collectors.toList()));
        boundValues.addAll(entityProperty.clusteringColumns.stream().map(x -> {
            AbstractProperty x1 = x;
            return BoundValueInfo.of(x1::encodeToSettable, x.getFieldValue(instance), x.encodeField(instance, Optional.ofNullable(cassandraOptions)));
        }).collect(Collectors.toList()));
        boundValues.addAll(entityProperty.normalColumns.stream().map(x -> {
            AbstractProperty x1 = x;
            return BoundValueInfo.of(x1::encodeToSettable, x.getFieldValue(instance), x.encodeField(instance, Optional.ofNullable(cassandraOptions)));
        }).collect(Collectors.toList()));
        boundValues.addAll(entityProperty.counterColumns.stream().map(x -> {
            AbstractProperty x1 = x;
            return BoundValueInfo.of(x1::encodeToSettable, x.getFieldValue(instance), x.encodeField(instance, Optional.ofNullable(cassandraOptions)));
        }).collect(Collectors.toList()));
        Optional<Optional<Integer>> ttl = OverridingOptional.from(cassandraOptions.getTimeToLive()).andThen(entityProperty.staticTTL).getOptional();
        boundValues.add(ttl.isPresent() ? BoundValueInfo.of((value, settableData) -> settableData.setInt("ttl", ((Integer)ttl.get()).intValue()), ttl.get(), ttl.get()) : BoundValueInfo.of((value, settableData) -> settableData.setInt("ttl", 0), 0, 0));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Extracted encoded bound values : %s", boundValues));
        }
        return new BoundValuesWrapper(entityProperty, boundValues);
    }

    public static <T> Tuple2<Object[], Object[]> extractPrimaryKeyValues(T instance, AbstractEntityProperty<T> entityProperty, Optional<CassandraOptions> cassandraOptions) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Extract primary key values from entity %s of type %s", instance, entityProperty.entityClass.getCanonicalName()));
        }
        Stream<Tuple2> partitionKeys = entityProperty.partitionKeys.stream().map(x -> Tuple2.of(x.getFieldValue(instance), x.encodeField(instance, cassandraOptions)));
        Stream<Tuple2> partitionKeysCopy = entityProperty.partitionKeys.stream().map(x -> Tuple2.of(x.getFieldValue(instance), x.encodeField(instance, cassandraOptions)));
        Stream<Tuple2> clusteringColumns = entityProperty.clusteringColumns.stream().map(x -> Tuple2.of(x.getFieldValue(instance), x.encodeField(instance, cassandraOptions)));
        Stream<Tuple2> clusteringColumnsCopy = entityProperty.clusteringColumns.stream().map(x -> Tuple2.of(x.getFieldValue(instance), x.encodeField(instance, cassandraOptions)));
        Object[] boundValues = ArrayUtils.addAll((Object[])partitionKeys.map(x -> x._1()).toArray(), (Object[])clusteringColumns.map(x -> x._1()).toArray());
        Object[] encodedValues = ArrayUtils.addAll((Object[])partitionKeysCopy.map(x -> x._2()).toArray(), (Object[])clusteringColumnsCopy.map(x -> x._2()).toArray());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Extracted primary key (encoded) : %s", encodedValues));
        }
        return Tuple2.of((Object)boundValues, (Object)encodedValues);
    }

    public static <T> BoundValuesWrapper extractPartitionKeysAndStaticValues(T instance, AbstractEntityProperty<T> entityProperty, CassandraOptions cassandraOptions) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Extract partition key values and static columns from entity %s of type %s", instance, entityProperty.entityClass.getCanonicalName()));
        }
        ArrayList<BoundValueInfo> boundValues = new ArrayList<BoundValueInfo>();
        List partitionKeys = entityProperty.partitionKeys.stream().map(x -> {
            AbstractProperty x1 = x;
            BiConsumer<Object, SettableData> lambda = x1::encodeToSettable;
            return BoundValueInfo.of(lambda, x.getFieldValue(instance), x.encodeField(instance, Optional.ofNullable(cassandraOptions)));
        }).collect(Collectors.toList());
        boundValues.addAll(partitionKeys);
        boundValues.addAll(entityProperty.staticColumns.stream().map(x -> {
            AbstractProperty x1 = x;
            return BoundValueInfo.of(x1::encodeToSettable, x.getFieldValue(instance), x.encodeField(instance, Optional.ofNullable(cassandraOptions)));
        }).collect(Collectors.toList()));
        Optional<Optional<Integer>> ttl = OverridingOptional.from(cassandraOptions.getTimeToLive()).andThen(entityProperty.staticTTL).getOptional();
        boundValues.add(ttl.isPresent() ? BoundValueInfo.of((value, settableData) -> settableData.setInt("ttl", ((Integer)ttl.get()).intValue()), ttl.get(), ttl.get()) : BoundValueInfo.of((value, settableData) -> settableData.setInt("ttl", 0), 0, 0));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Extracted encoded bound values : %s", boundValues));
        }
        return new BoundValuesWrapper(entityProperty, boundValues);
    }
}

