/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.runtime;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.extras.codecs.arrays.DoubleArrayCodec;
import com.datastax.driver.extras.codecs.arrays.FloatArrayCodec;
import com.datastax.driver.extras.codecs.arrays.IntArrayCodec;
import com.datastax.driver.extras.codecs.arrays.LongArrayCodec;
import com.datastax.driver.extras.codecs.jdk8.InstantCodec;
import com.datastax.driver.extras.codecs.jdk8.LocalDateCodec;
import com.datastax.driver.extras.codecs.jdk8.LocalTimeCodec;
import com.datastax.driver.extras.codecs.jdk8.ZonedDateTimeCodec;
import info.archinnov.achilles.internals.cassandra_version.InternalCassandraVersion;
import info.archinnov.achilles.internals.context.ConfigurationContext;
import info.archinnov.achilles.internals.factory.TupleTypeFactory;
import info.archinnov.achilles.internals.factory.UserTypeFactory;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.metamodel.AbstractUDTClassProperty;
import info.archinnov.achilles.internals.metamodel.AbstractViewProperty;
import info.archinnov.achilles.internals.metamodel.functions.FunctionProperty;
import info.archinnov.achilles.internals.runtime.RuntimeEngine;
import info.archinnov.achilles.internals.schema.SchemaCreator;
import info.archinnov.achilles.internals.utils.CodecRegistryHelper;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractManagerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractManagerFactory.class);
    protected final Cluster cluster;
    protected final ConfigurationContext configContext;
    protected final RuntimeEngine rte;
    protected List<AbstractEntityProperty<?>> entityProperties;
    protected List<Class<?>> entityClasses;
    protected List<FunctionProperty> functionProperties;

    public AbstractManagerFactory(Cluster cluster, ConfigurationContext configContext) {
        this.cluster = cluster;
        this.configContext = configContext;
        this.rte = new RuntimeEngine(configContext);
    }

    protected abstract InternalCassandraVersion getCassandraVersion();

    protected abstract List<AbstractUDTClassProperty<?>> getUdtClassProperties();

    public Optional<String> staticTableNameFor(Class<?> entityClass) {
        Optional<String> tableName = this.entityProperties.stream().filter(x -> x.entityClass.equals(entityClass)).map(x -> x.getKeyspace().map(ks -> ks + "." + x.getTableOrViewName()).orElseGet(x::getTableOrViewName)).findFirst();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Determining table name for entity type %s : %s", entityClass.getCanonicalName(), tableName));
        }
        return tableName;
    }

    @PreDestroy
    public void shutDown() {
        LOGGER.info("Calling shutdown on ManagerFactory");
        if (!this.configContext.isProvidedSession()) {
            LOGGER.info(String.format("Closing built Session object %s", this.rte.session));
            this.rte.session.close();
        }
        if (!this.configContext.isProvidedExecutorService()) {
            LOGGER.info(String.format("Closing built executor service (thread pool) %s", this.configContext.getExecutorService()));
            this.configContext.getExecutorService().shutdown();
        }
    }

    protected void bootstrap() {
        this.addNativeCodecs();
        this.injectDependencies();
        if (this.configContext.isForceSchemaGeneration()) {
            this.createSchema();
        }
        if (this.configContext.isValidateSchema()) {
            this.validateSchema();
        }
        this.prepareStaticStatements();
    }

    protected void addNativeCodecs() {
        LOGGER.trace("Add Java Driver extra codecs");
        Configuration configuration = this.cluster.getConfiguration();
        TupleType zonedDateTimeType = TupleType.of((ProtocolVersion)configuration.getProtocolOptions().getProtocolVersion(), (CodecRegistry)configuration.getCodecRegistry(), (DataType[])new DataType[]{DataType.timestamp(), DataType.varchar()});
        CodecRegistry codecRegistry = configuration.getCodecRegistry();
        CodecRegistryHelper codecRegistryHelper = new CodecRegistryHelper(codecRegistry);
        if (!codecRegistryHelper.hasCodecFor((DataType)DataType.list((DataType)DataType.cdouble()), double[].class)) {
            codecRegistry.register((TypeCodec)DoubleArrayCodec.instance);
        }
        if (!codecRegistryHelper.hasCodecFor((DataType)DataType.list((DataType)DataType.cfloat()), float[].class)) {
            codecRegistry.register((TypeCodec)FloatArrayCodec.instance);
        }
        if (!codecRegistryHelper.hasCodecFor((DataType)DataType.list((DataType)DataType.cint()), int[].class)) {
            codecRegistry.register((TypeCodec)IntArrayCodec.instance);
        }
        if (!codecRegistryHelper.hasCodecFor((DataType)DataType.list((DataType)DataType.bigint()), long[].class)) {
            codecRegistry.register((TypeCodec)LongArrayCodec.instance);
        }
        if (!codecRegistryHelper.hasCodecFor(DataType.timestamp(), Instant.class)) {
            codecRegistry.register((TypeCodec)InstantCodec.instance);
        }
        if (!codecRegistryHelper.hasCodecFor(DataType.date(), LocalDate.class)) {
            codecRegistry.register((TypeCodec)LocalDateCodec.instance);
        }
        if (!codecRegistryHelper.hasCodecFor(DataType.time(), LocalTime.class)) {
            codecRegistry.register((TypeCodec)LocalTimeCodec.instance);
        }
        if (!codecRegistryHelper.hasCodecFor((DataType)zonedDateTimeType, ZonedDateTime.class)) {
            codecRegistry.register((TypeCodec)new ZonedDateTimeCodec(zonedDateTimeType));
        }
    }

    protected void injectDependencies() {
        CodecRegistry codecRegistry = this.cluster.getConfiguration().getCodecRegistry();
        ProtocolVersion protocolVersion = this.cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
        TupleTypeFactory tupleTypeFactory = new TupleTypeFactory(protocolVersion, codecRegistry);
        UserTypeFactory userTypeFactory = new UserTypeFactory(protocolVersion, codecRegistry);
        this.rte.tupleTypeFactory = tupleTypeFactory;
        this.rte.userTypeFactory = userTypeFactory;
        List<Class<?>> manageEntities = this.configContext.getManageEntities().isEmpty() ? this.entityClasses : this.configContext.getManageEntities();
        this.entityProperties.stream().filter(x -> manageEntities.contains(x.entityClass)).forEach(x -> this.configContext.injectDependencies(tupleTypeFactory, userTypeFactory, (AbstractEntityProperty<?>)x));
    }

    protected void validateSchema() {
        List<Class<?>> manageEntities = this.configContext.getManageEntities().isEmpty() ? this.entityClasses : this.configContext.getManageEntities();
        this.entityProperties.stream().filter(x -> manageEntities.contains(x.entityClass)).forEach(x -> x.validateSchema(this.configContext));
        this.functionProperties.stream().forEach(x -> x.validate(this.configContext));
    }

    protected void createSchema() {
        Session session = this.configContext.getSession();
        List<Class<?>> manageEntities = this.configContext.getManageEntities().isEmpty() ? this.entityClasses : this.configContext.getManageEntities();
        for (AbstractUDTClassProperty<?> x2 : this.getUdtClassProperties()) {
            long udtCountForClass = this.entityProperties.stream().filter(entityProperty -> manageEntities.contains(entityProperty.entityClass)).flatMap(entityProperty -> entityProperty.allColumns.stream()).filter(property -> property.containsUDTProperty()).filter(property -> property.getUDTClassProperties().contains(x2)).count();
            if (udtCountForClass <= 0L) continue;
            SchemaCreator.generateUDTAtRuntime(session, x2);
        }
        long viewCount = this.entityProperties.stream().filter(AbstractEntityProperty::isView).count();
        if (viewCount > 0L) {
            Map<Class, AbstractEntityProperty> entityPropertiesMap = this.entityProperties.stream().filter(AbstractEntityProperty::isTable).collect(Collectors.toMap(x -> x.entityClass, x -> x));
            this.entityProperties.stream().filter(AbstractEntityProperty::isView).map(x -> (AbstractViewProperty)x).forEach(x -> x.setBaseClassProperty((AbstractEntityProperty)entityPropertiesMap.get(x.getBaseEntityClass())));
        }
        this.entityProperties.stream().filter(x -> manageEntities.contains(x.entityClass)).forEach(x -> SchemaCreator.generateSchemaAtRuntime(session, x));
    }

    protected void prepareStaticStatements() {
        List<Class<?>> manageEntities = this.configContext.getManageEntities().isEmpty() ? this.entityClasses : this.configContext.getManageEntities();
        this.entityProperties.stream().filter(x -> manageEntities.contains(x.entityClass)).forEach(x -> x.prepareStaticStatements(this.getCassandraVersion(), this.configContext.getSession(), this.rte.cache));
    }
}

