/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.parser.validator;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.WildcardTypeName;
import info.archinnov.achilles.internals.apt.AptUtils;
import java.util.List;

public abstract class TypeValidator {
    public abstract List<TypeName> getAllowedTypes();

    public void validateAllowedTypes(AptUtils aptUtils, TypeName parentType, TypeName type) {
        if (type.isPrimitive()) {
            return;
        }
        if (type instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)type;
            this.validateAllowedTypes(aptUtils, parentType, (TypeName)parameterizedTypeName.rawType);
            for (TypeName x : parameterizedTypeName.typeArguments) {
                this.validateAllowedTypes(aptUtils, parentType, x);
            }
        } else if (type instanceof WildcardTypeName) {
            WildcardTypeName wildcardTypeName = (WildcardTypeName)type;
            for (TypeName x : wildcardTypeName.upperBounds) {
                this.validateAllowedTypes(aptUtils, parentType, x);
            }
        } else if (type instanceof ClassName || type instanceof ArrayTypeName) {
            boolean isValidType = this.getAllowedTypes().contains(type);
            aptUtils.validateTrue(isValidType, "Type '%s' in '%s' is not a valid type for CQL", type.toString(), parentType.toString());
        } else {
            aptUtils.printError("Type '%s' in '%s' is not a valid type for CQL", type.toString(), parentType.toString());
        }
    }

    public void validateAllowedTypesForFunction(AptUtils aptUtils, String className, String methodName, TypeName type) {
        if (type.isPrimitive()) {
            this.validateAllowedTypesForFunction(aptUtils, className, methodName, type.box());
        } else if (type instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)type;
            this.validateAllowedTypesForFunction(aptUtils, className, methodName, (TypeName)parameterizedTypeName.rawType);
            for (TypeName x : parameterizedTypeName.typeArguments) {
                this.validateAllowedTypesForFunction(aptUtils, className, methodName, x);
            }
        } else if (type instanceof WildcardTypeName) {
            WildcardTypeName wildcardTypeName = (WildcardTypeName)type;
            for (TypeName x : wildcardTypeName.upperBounds) {
                this.validateAllowedTypesForFunction(aptUtils, className, methodName, x);
            }
        } else if (type instanceof ClassName || type instanceof ArrayTypeName) {
            boolean isValidType = this.getAllowedTypes().contains(type);
            aptUtils.validateTrue(isValidType, "Type '%s' in method '%s' return type/parameter on class '%s' is not a valid native Java type for Cassandra", type.toString(), methodName, className);
        } else {
            aptUtils.printError("Type '%s' in method '%s' return type/parameter on class '%s' is not a valid native Java type for Cassandra", type.toString(), methodName, className);
        }
    }
}

