/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.parser.validator;

import com.squareup.javapoet.TypeName;
import info.archinnov.achilles.annotations.ASCII;
import info.archinnov.achilles.annotations.ClusteringColumn;
import info.archinnov.achilles.annotations.Codec;
import info.archinnov.achilles.annotations.Computed;
import info.archinnov.achilles.annotations.Counter;
import info.archinnov.achilles.annotations.DSE_Search;
import info.archinnov.achilles.annotations.Enumerated;
import info.archinnov.achilles.annotations.Frozen;
import info.archinnov.achilles.annotations.Index;
import info.archinnov.achilles.annotations.JSON;
import info.archinnov.achilles.annotations.PartitionKey;
import info.archinnov.achilles.annotations.RuntimeCodec;
import info.archinnov.achilles.annotations.SASI;
import info.archinnov.achilles.annotations.Static;
import info.archinnov.achilles.annotations.TimeUUID;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.metamodel.columns.KeyColumnInfo;
import info.archinnov.achilles.internals.parser.FieldParser;
import info.archinnov.achilles.internals.parser.context.CodecContext;
import info.archinnov.achilles.internals.parser.context.FieldParsingContext;
import info.archinnov.achilles.internals.parser.context.GlobalParsingContext;
import info.archinnov.achilles.internals.parser.validator.TypeValidator;
import info.archinnov.achilles.type.tuples.Tuple2;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Name;
import javax.lang.model.element.VariableElement;

public abstract class FieldValidator {
    public abstract List<TypeName> getAllowedTypes();

    public abstract void validateCompatibleIndexAnnotationsOnField(GlobalParsingContext var1, AptUtils var2, String var3, TypeName var4, Optional<Index> var5, Optional<SASI> var6, Optional<DSE_Search> var7);

    public abstract void validateSASIIndex(AptUtils var1, FieldParser.FieldMetaSignature var2);

    public abstract void validateDSESearchIndex(AptUtils var1, FieldParser.FieldMetaSignature var2);

    public void checkNoMutuallyExclusiveAnnotations(AptUtils aptUtils, String fieldName, TypeName rawEntityClass, List<Optional<? extends Annotation>> annotations) {
        annotations.stream().filter(annotation -> annotation.isPresent()).forEach(annotation -> {
            ArrayList shifted = new ArrayList(annotations);
            shifted.remove(annotation);
            shifted.stream().filter(shiftedAnnotation -> shiftedAnnotation.isPresent()).forEach(shiftedAnnotation -> {
                String annot1 = "@" + ((Annotation)annotation.get()).annotationType().getSimpleName();
                String annot2 = "@" + ((Annotation)shiftedAnnotation.get()).annotationType().getSimpleName();
                aptUtils.printError("Field '%s' in class '%s' cannot have both %s AND %s annotations", fieldName, rawEntityClass, annot1, annot2);
            });
        });
    }

    public void checkNoMutuallyExclusiveCodecAnnotations(AptUtils aptUtils, String fieldName, Name rawEntityClass, List<? extends Annotation> annotations) {
        ArrayList<? extends Annotation> shifted = new ArrayList<Annotation>(annotations);
        Annotation first = shifted.remove(0);
        shifted.add(first);
        for (int i = 0; i < annotations.size(); ++i) {
            Annotation annotation = annotations.get(i);
            Annotation shiftedAnnotation = shifted.get(i);
            if (annotation == null || shiftedAnnotation == null) continue;
            String annot1 = "@" + annotation.annotationType().getSimpleName();
            String annot2 = "@" + shiftedAnnotation.annotationType().getSimpleName();
            aptUtils.printError("Cannot have both %s and % annotation on the same field '%s' in class '%s'", fieldName, rawEntityClass, annot1, annot2);
        }
    }

    public void checkNoMutuallyExclusiveCodecAnnotations(AptUtils aptUtils, String fieldName, Name rawEntityClass, Annotation left, List<? extends Annotation> right) {
        if (left != null) {
            for (int i = 0; i < right.size(); ++i) {
                Annotation annotation = right.get(i);
                if (annotation == null) continue;
                String annot1 = "@" + annotation.getClass().getSimpleName();
                String annot2 = "@" + left.getClass().getSimpleName();
                aptUtils.printError("Cannot have both %s and %s annotation on the same field '%s' in class '%s'", fieldName, rawEntityClass, annot1, annot2);
            }
        }
    }

    public void validateCompatibleColumnAnnotationsOnField(AptUtils aptUtils, String fieldName, TypeName rawEntityClass, Optional<PartitionKey> partitionKey, Optional<ClusteringColumn> clusteringColumn, Optional<Static> staticColumn, Optional<Computed> computed, Optional<Counter> counter) {
        this.checkNoMutuallyExclusiveAnnotations(aptUtils, fieldName, rawEntityClass, Arrays.asList(partitionKey, clusteringColumn, staticColumn, computed));
        this.checkNoMutuallyExclusiveAnnotations(aptUtils, fieldName, rawEntityClass, Arrays.asList(computed, counter));
    }

    public void validateCompatibleCodecAnnotationsOnField(AptUtils aptUtils, String fieldName, Name className, Frozen frozen, JSON json, Enumerated enumerated, Codec codec, RuntimeCodec runtimeCodec, Computed computed, Counter counter, TimeUUID timeUUID, ASCII ascii) {
        this.checkNoMutuallyExclusiveCodecAnnotations(aptUtils, fieldName, className, Arrays.asList(json, codec, runtimeCodec, enumerated, frozen));
        this.checkNoMutuallyExclusiveCodecAnnotations(aptUtils, fieldName, className, (Annotation)computed, Arrays.asList(frozen, json, enumerated));
        this.checkNoMutuallyExclusiveCodecAnnotations(aptUtils, fieldName, className, (Annotation)counter, Arrays.asList(frozen, json, enumerated, computed));
        this.checkNoMutuallyExclusiveCodecAnnotations(aptUtils, fieldName, className, (Annotation)timeUUID, Arrays.asList(frozen, json, enumerated, codec, runtimeCodec, computed, counter, ascii));
        this.checkNoMutuallyExclusiveCodecAnnotations(aptUtils, fieldName, className, (Annotation)ascii, Arrays.asList(frozen, json, enumerated, codec, runtimeCodec, computed, counter, timeUUID));
    }

    public void validateAllowedFrozen(boolean isFrozen, AptUtils aptUtils, VariableElement elm, String fieldName, TypeName rawClass) {
        if (isFrozen) {
            aptUtils.validateTrue(aptUtils.isCompositeTypeForCassandra(elm.asType()), "@Frozen annotation on field '%s' of class '%s' is only allowed for collections and UDT", fieldName, rawClass);
        }
    }

    public void validateAllowedType(AptUtils aptUtils, TypeName rawTargetType, FieldParsingContext context) {
        aptUtils.validateTrue(this.getAllowedTypes().contains(rawTargetType), "Impossible to parse type '%s' from field '%s' of class '%s'. It should be a supported type", rawTargetType.toString(), context.fieldName, context.className);
    }

    public void validateCounter(AptUtils aptUtils, TypeName targetType, Set<Class<? extends Annotation>> annotations, FieldParsingContext context) {
        if (AptUtils.containsAnnotation(annotations, Counter.class)) {
            aptUtils.validateTrue(targetType.box().equals((Object)TypeName.LONG.box()), "Field '%s' of class '%s' annotated with @Counter should be of type Long/long", context.fieldName, context.className);
        }
    }

    public void validateCorrectKeysOrder(AptUtils aptUtils, TypeName rawClassName, List<Tuple2<String, KeyColumnInfo>> keyTuples, String type) {
        Integer sumOfOrders;
        int checkForKeyOrdering = keyTuples.size() * (keyTuples.size() + 1) / 2;
        aptUtils.validateTrue(checkForKeyOrdering == (sumOfOrders = keyTuples.stream().map(x -> (KeyColumnInfo)x._2()).collect(Collectors.summingInt(x -> x.order()))), "The %s ordering is wrong in class '%s'", type, rawClassName);
    }

    public CodecContext validateCodec(AptUtils aptUtils, TypeValidator typeValidator, CodecContext codecContext, TypeName sourceType, Optional<TypeName> cqlClass, boolean isCounter) {
        String codecClass = codecContext.codecType.toString();
        aptUtils.validateTrue(sourceType.box().equals((Object)codecContext.sourceType.box()), "Codec '%s' source type '%s' should match current object type '%s'", codecClass, codecContext.sourceType, sourceType.toString());
        if (cqlClass.isPresent()) {
            aptUtils.validateTrue(codecContext.targetType.box().equals((Object)cqlClass.get().box()), "Codec '%s' target type '%s' should match computed CQL type '%s'", codecClass, codecContext.targetType, cqlClass.get());
        }
        if (isCounter) {
            aptUtils.validateTrue(codecContext.targetType.box().equals((Object)TypeName.LONG.box()), "Codec '%s' target type '%s' should be Long/long because the column is annotated with @Counter", codecClass, codecContext.targetType);
        }
        typeValidator.validateAllowedTypes(aptUtils, sourceType, codecContext.targetType);
        return codecContext;
    }
}

