/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.parser.validator;

import com.squareup.javapoet.TypeName;
import info.archinnov.achilles.annotations.EntityCreator;
import info.archinnov.achilles.annotations.Immutable;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.codegen.meta.EntityMetaCodeGen;
import info.archinnov.achilles.internals.metamodel.columns.ColumnType;
import info.archinnov.achilles.internals.metamodel.columns.ComputedColumnInfo;
import info.archinnov.achilles.internals.parser.FieldParser;
import info.archinnov.achilles.internals.parser.context.ConstructorInfo;
import info.archinnov.achilles.type.tuples.Tuple2;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.apache.commons.collections.map.HashedMap;

public abstract class BeanValidator {
    public final List<String> RESERVED_KEYWORDS = Arrays.asList("add,allow,alter,and,any,apply,asc,authorize,batch,begin,by,columnfamily,create,delete,desc,drop,each_quorum,from,grant,in,index,inet,infinity,insert,into,keyspace,keyspaces,limit,local_one,local_quorum,modify,nan,norecursive,of,on,order,primary,quorum,rename,revoke,schema,select,set,table,three,to,token,truncate,two,unlogged,update,use,using,where,with".split(","));

    public void validateEntityNames(AptUtils aptUtils, List<TypeElement> entityTypes) {
        HashedMap entities = new HashedMap();
        for (TypeElement entityType : entityTypes) {
            String className = entityType.getSimpleName().toString();
            String FQCN = entityType.getQualifiedName().toString();
            if (entities.containsKey(className)) {
                String existingFQCN = (String)entities.get(className);
                aptUtils.printError("%s and %s both share the same class name, it is forbidden by Achilles", FQCN, existingFQCN);
                throw new IllegalStateException(String.format("%s and %s both share the same class name, it is forbidden by Achilles", FQCN, existingFQCN));
            }
            entities.put(className, FQCN);
        }
    }

    public void validateIsAConcreteClass(AptUtils aptUtils, TypeElement typeElement) {
        Name name = typeElement.getQualifiedName();
        aptUtils.validateTrue(typeElement.getKind() == ElementKind.CLASS, "Bean type '%s' should be a class", name);
        Set<Modifier> modifiers = typeElement.getModifiers();
        aptUtils.validateFalse(modifiers.contains((Object)Modifier.ABSTRACT), "Bean type '%s' should not be abstract", name);
    }

    public ConstructorInfo validateConstructor(AptUtils aptUtils, TypeName typeName, TypeElement typeElement) {
        Optional<Immutable> immutable = aptUtils.getAnnotationOnClass(typeElement, Immutable.class);
        long customConstructorCount = ElementFilter.constructorsIn(typeElement.getEnclosedElements()).stream().filter(x -> x.getModifiers().contains((Object)Modifier.PUBLIC)).filter(x -> x.getParameters().size() > 0).count();
        long defaultConstructorCount = ElementFilter.constructorsIn(typeElement.getEnclosedElements()).stream().filter(x -> x.getModifiers().contains((Object)Modifier.PUBLIC)).filter(x -> x.getParameters().size() == 0).count();
        long entityCreatorConstructorCount = ElementFilter.constructorsIn(typeElement.getEnclosedElements()).stream().filter(x -> x.getModifiers().contains((Object)Modifier.PUBLIC)).filter(x -> x.getParameters().size() > 0).filter(x -> x.getAnnotation(EntityCreator.class) != null).count();
        aptUtils.validateTrue(immutable.isPresent() && customConstructorCount == 1L && defaultConstructorCount == 0L || entityCreatorConstructorCount == 1L || defaultConstructorCount == 1L, "Entity type '%s' should:\n\t1. either be annotated with @Immutable, have NO default constructor and EXACTLY 1 custom constructor\n\t2. or have EXACTLY 1 custom constructor annotated with @EntityCreator and optionally one default constructor and multiple other custom constructors\n\t3. or have EXACTLY 1 default constructor and one or more custom constructor(s) (nominal scenario)\n", typeName);
        if (immutable.isPresent() && customConstructorCount == 1L && defaultConstructorCount == 0L) {
            ExecutableElement constructor = ElementFilter.constructorsIn(typeElement.getEnclosedElements()).stream().filter(x -> x.getModifiers().contains((Object)Modifier.PUBLIC)).filter(x -> x.getParameters().size() > 0).findFirst().get();
            return ConstructorInfo.immutable(constructor);
        }
        if (entityCreatorConstructorCount == 1L) {
            ExecutableElement constructor = ElementFilter.constructorsIn(typeElement.getEnclosedElements()).stream().filter(x -> x.getModifiers().contains((Object)Modifier.PUBLIC)).filter(x -> x.getParameters().size() > 0).filter(x -> x.getAnnotation(EntityCreator.class) != null).findFirst().get();
            return ConstructorInfo.entityCreator(constructor);
        }
        if (defaultConstructorCount == 1L) {
            ExecutableElement constructor = ElementFilter.constructorsIn(typeElement.getEnclosedElements()).stream().filter(x -> x.getModifiers().contains((Object)Modifier.PUBLIC)).filter(x -> x.getParameters().size() == 0).findFirst().get();
            return ConstructorInfo.defaultConstructor(constructor);
        }
        aptUtils.printError("Cannot determine appropriate constructor type for entity type '%s'", typeName);
        throw new IllegalStateException(String.format("Cannot determine appropriate constructor type for entity type '%s'", typeElement));
    }

    public void validateNoDuplicateNames(AptUtils aptUtils, TypeName rawClassType, List<FieldParser.FieldMetaSignature> parsingResults) {
        HashMap mapping = new HashMap();
        parsingResults.stream().map(x -> x.context).forEach(context -> {
            String fieldName = context.fieldName;
            String cqlColumn = context.cqlColumn;
            if (mapping.containsKey(fieldName)) {
                aptUtils.printError("The class '%s' already contains a field with name '%s'", rawClassType, fieldName);
            } else if (mapping.containsValue(cqlColumn)) {
                aptUtils.printError("The class '%s' already contains a cql column with name '%s'", rawClassType, cqlColumn);
            } else {
                mapping.put(fieldName, cqlColumn);
            }
        });
    }

    public void validateCqlColumnNotReservedWords(AptUtils aptUtils, TypeName rawClassType, List<FieldParser.FieldMetaSignature> parsingResults) {
        parsingResults.stream().map(x -> Tuple2.of((Object)x.context.cqlColumn, (Object)x.context.fieldName)).forEach(x -> aptUtils.validateFalse(this.RESERVED_KEYWORDS.contains(((String)x._1()).toLowerCase()), "The cql column '%s' on field '%s' of class '%s' is a CQL reserved word and cannot be used", x._1(), x._2(), rawClassType));
    }

    public void validateStaticColumns(AptUtils aptUtils, TypeName rawClassType, List<FieldParser.FieldMetaSignature> parsingResults) {
        boolean hasClustering;
        boolean hasStatic = parsingResults.stream().filter(x -> x.context.columnType == ColumnType.STATIC || x.context.columnType == ColumnType.STATIC_COUNTER).count() > 0L;
        boolean bl = hasClustering = parsingResults.stream().filter(x -> x.context.columnType == ColumnType.CLUSTERING).count() > 0L;
        if (hasStatic) {
            aptUtils.validateTrue(hasClustering, "The class '%s' cannot have static columns without at least 1 clustering column", rawClassType);
        }
    }

    public void validateNoStaticColumnsForView(AptUtils aptUtils, TypeName rawClassType, List<FieldParser.FieldMetaSignature> parsingResults) {
    }

    public void validateHasPartitionKey(AptUtils aptUtils, TypeName rawClassType, List<FieldParser.FieldMetaSignature> parsingResults) {
        boolean hasPartitionKey = parsingResults.stream().filter(x -> x.context.columnType == ColumnType.PARTITION).count() > 0L;
        aptUtils.validateTrue(hasPartitionKey, "The class '%s' should have at least 1 partition key (@PartitionKey)", rawClassType);
    }

    public boolean isCounterTable(AptUtils aptUtils, TypeName rawClassType, List<FieldParser.FieldMetaSignature> parsingResults) {
        boolean hasNormal;
        boolean hasCounter = parsingResults.stream().filter(x -> x.context.columnType == ColumnType.COUNTER).count() > 0L;
        boolean hasStaticCounter = parsingResults.stream().filter(x -> x.context.columnType == ColumnType.STATIC_COUNTER).count() > 0L;
        boolean bl = hasNormal = parsingResults.stream().filter(x -> x.context.columnType == ColumnType.NORMAL).count() > 0L;
        if (hasCounter || hasStaticCounter) {
            aptUtils.validateFalse(hasNormal, "Class '%s' should not mix counter and normal columns", rawClassType);
        }
        return hasCounter || hasStaticCounter;
    }

    public void validateComputed(AptUtils aptUtils, TypeName rawClassType, List<FieldParser.FieldMetaSignature> parsingResults) {
        List fieldNames = parsingResults.stream().map(x -> x.context.fieldName).collect(Collectors.toList());
        HashSet aliases = new HashSet();
        parsingResults.stream().filter(x -> x.context.columnType == ColumnType.COMPUTED).map(x -> Tuple2.of((Object)x.context.fieldName, (Object)((ComputedColumnInfo)x.context.columnInfo).alias)).forEach(x -> {
            aptUtils.validateFalse(aliases.contains(x._2()), "Alias '%s' in @Computed annotation on field '%s' is already used by another @Computed field", x._2(), x._1());
            if (!aliases.contains(x._2())) {
                aliases.add(x._2());
            }
        });
        parsingResults.stream().filter(x -> x.context.columnType == ColumnType.COMPUTED).forEach(x -> {
            ComputedColumnInfo columnInfo = (ComputedColumnInfo)x.context.columnInfo;
            for (String column : columnInfo.functionArgs) {
                aptUtils.validateTrue(fieldNames.contains(column), "Target field '%s' in @Computed annotation of field '%s' of class '%s' does not exist", column, x.context.fieldName, rawClassType);
            }
        });
    }

    public void validateViewsAgainstBaseTable(AptUtils aptUtils, List<EntityMetaCodeGen.EntityMetaSignature> viewSignatures, List<EntityMetaCodeGen.EntityMetaSignature> entitySignatures) {
    }
}

