/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.parser;

import com.squareup.javapoet.TypeName;
import info.archinnov.achilles.annotations.Computed;
import info.archinnov.achilles.annotations.Counter;
import info.archinnov.achilles.annotations.Frozen;
import info.archinnov.achilles.annotations.JSON;
import info.archinnov.achilles.annotations.Strategy;
import info.archinnov.achilles.annotations.TimeUUID;
import info.archinnov.achilles.annotations.UDT;
import info.archinnov.achilles.exception.AchillesBeanMappingException;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.parser.AnnotationTree;
import info.archinnov.achilles.internals.parser.CodecFactory;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.UDTParser;
import info.archinnov.achilles.internals.parser.context.FunctionSignature;
import info.archinnov.achilles.internals.parser.context.GlobalParsingContext;
import info.archinnov.achilles.internals.strategy.naming.InternalNamingStrategy;
import info.archinnov.achilles.type.tuples.Tuple1;
import info.archinnov.achilles.type.tuples.Tuple10;
import info.archinnov.achilles.type.tuples.Tuple2;
import info.archinnov.achilles.type.tuples.Tuple3;
import info.archinnov.achilles.type.tuples.Tuple4;
import info.archinnov.achilles.type.tuples.Tuple5;
import info.archinnov.achilles.type.tuples.Tuple6;
import info.archinnov.achilles.type.tuples.Tuple7;
import info.archinnov.achilles.type.tuples.Tuple8;
import info.archinnov.achilles.type.tuples.Tuple9;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.lang3.StringUtils;

public class FunctionParamParser {
    private final AptUtils aptUtils;
    private final CodecFactory codecFactory;
    private final UDTParser udtParser;

    public FunctionParamParser(AptUtils aptUtils) {
        this.aptUtils = aptUtils;
        this.codecFactory = new CodecFactory(aptUtils);
        this.udtParser = new UDTParser(aptUtils);
    }

    public FunctionSignature.FunctionParamSignature parseParam(GlobalParsingContext context, AnnotationTree annotationTree, TypeName parentType, String methodName, String paramName) {
        boolean isUDT;
        TypeMirror currentTypeMirror = annotationTree.getCurrentType();
        TypeName sourceType = TypeName.get((TypeMirror)currentTypeMirror).box();
        boolean bl = isUDT = currentTypeMirror.getKind() == TypeKind.DECLARED && this.aptUtils.getAnnotationOnClass(currentTypeMirror, UDT.class).isPresent();
        if (AptUtils.containsAnnotation(annotationTree, JSON.class)) {
            return new FunctionSignature.FunctionParamSignature(paramName, sourceType, TypeUtils.STRING, "text");
        }
        if (AptUtils.containsAnnotation(annotationTree, Computed.class)) {
            throw new AchillesBeanMappingException(String.format("Cannot have @Computed annotation on param '%s' of method '%s''", paramName, methodName));
        }
        if (this.aptUtils.isAssignableFrom(Tuple1.class, currentTypeMirror)) {
            return this.parseTuple1(context, annotationTree, parentType, methodName, paramName);
        }
        if (this.aptUtils.isAssignableFrom(Tuple2.class, currentTypeMirror)) {
            return this.parseTuple2(context, annotationTree, parentType, methodName, paramName);
        }
        if (this.aptUtils.isAssignableFrom(Tuple3.class, currentTypeMirror)) {
            return this.parseTuple3(context, annotationTree, parentType, methodName, paramName);
        }
        if (this.aptUtils.isAssignableFrom(Tuple4.class, currentTypeMirror)) {
            return this.parseTuple4(context, annotationTree, parentType, methodName, paramName);
        }
        if (this.aptUtils.isAssignableFrom(Tuple5.class, currentTypeMirror)) {
            return this.parseTuple5(context, annotationTree, parentType, methodName, paramName);
        }
        if (this.aptUtils.isAssignableFrom(Tuple6.class, currentTypeMirror)) {
            return this.parseTuple6(context, annotationTree, parentType, methodName, paramName);
        }
        if (this.aptUtils.isAssignableFrom(Tuple7.class, currentTypeMirror)) {
            return this.parseTuple7(context, annotationTree, parentType, methodName, paramName);
        }
        if (this.aptUtils.isAssignableFrom(Tuple8.class, currentTypeMirror)) {
            return this.parseTuple8(context, annotationTree, parentType, methodName, paramName);
        }
        if (this.aptUtils.isAssignableFrom(Tuple9.class, currentTypeMirror)) {
            return this.parseTuple9(context, annotationTree, parentType, methodName, paramName);
        }
        if (this.aptUtils.isAssignableFrom(Tuple10.class, currentTypeMirror)) {
            return this.parseTuple10(context, annotationTree, parentType, methodName, paramName);
        }
        if (this.aptUtils.isAssignableFrom(List.class, currentTypeMirror)) {
            return this.parseList(context, annotationTree, parentType, methodName, paramName);
        }
        if (this.aptUtils.isAssignableFrom(Set.class, currentTypeMirror)) {
            return this.parseSet(context, annotationTree, parentType, methodName, paramName);
        }
        if (this.aptUtils.isAssignableFrom(Map.class, currentTypeMirror)) {
            return this.parseMap(context, annotationTree, parentType, methodName, paramName);
        }
        if (this.aptUtils.isAssignableFrom(Optional.class, currentTypeMirror)) {
            return this.parseOptional(context, annotationTree, parentType, methodName, paramName);
        }
        if (isUDT) {
            return this.parseUDT(context, annotationTree, paramName);
        }
        return this.parseSimpleType(context, annotationTree, parentType, methodName, paramName);
    }

    private FunctionSignature.FunctionParamSignature parseSimpleType(GlobalParsingContext context, AnnotationTree annotationTree, TypeName parentType, String methodName, String paramName) {
        TypeMirror typeMirror = annotationTree.getCurrentType();
        TypeName sourceType = TypeName.get((TypeMirror)typeMirror);
        TypeName typeNameFromRegistry = this.buildOrGetCodecFromRegistry(context, annotationTree, parentType, sourceType, methodName, paramName);
        TypeName rawTargetType = TypeUtils.getRawType(typeNameFromRegistry);
        this.aptUtils.validateTrue(context.typeValidator().getAllowedTypes().contains(rawTargetType), "Impossible to parse type '%s' from param '%s' of method '%s' on class '%s'. It should be a supported type", rawTargetType.toString(), paramName, methodName);
        if (AptUtils.containsAnnotation(annotationTree.getAnnotations().keySet(), Counter.class)) {
            this.aptUtils.validateTrue(rawTargetType.box().equals((Object)TypeName.LONG.box()), "Param '%s' of method '%s' on class '%s' annotated with @Counter should be of type Long/long", paramName, methodName);
        }
        if (AptUtils.containsAnnotation(annotationTree, TimeUUID.class)) {
            return new FunctionSignature.FunctionParamSignature(paramName, TypeUtils.UUID, TypeUtils.UUID, "timeuuid");
        }
        if (AptUtils.containsAnnotation(annotationTree, Counter.class)) {
            return new FunctionSignature.FunctionParamSignature(paramName, TypeUtils.OBJECT_LONG, TypeUtils.OBJECT_LONG, "counter");
        }
        return new FunctionSignature.FunctionParamSignature(paramName, sourceType, rawTargetType.box(), TypeUtils.DRIVER_TYPES_FUNCTION_PARAM_MAPPING.get(rawTargetType));
    }

    protected FunctionSignature.FunctionParamSignature parseTuple1(GlobalParsingContext context, AnnotationTree annotationTree, TypeName parentType, String methodName, String paramName) {
        FunctionSignature.FunctionParamSignature parsingResult = this.parseParam(context, annotationTree.next(), parentType, methodName, paramName);
        return FunctionSignature.FunctionParamSignature.tupleType(paramName, TypeUtils.TUPLE1, parsingResult);
    }

    protected FunctionSignature.FunctionParamSignature parseTuple2(GlobalParsingContext context, AnnotationTree annotationTree, TypeName parentType, String methodName, String paramName) {
        AnnotationTree annotationTree1 = annotationTree.next();
        AnnotationTree annotationTree2 = annotationTree1.next();
        FunctionSignature.FunctionParamSignature parsingResult1 = this.parseParam(context, annotationTree1, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult2 = this.parseParam(context, annotationTree2, parentType, methodName, paramName);
        return FunctionSignature.FunctionParamSignature.tupleType(paramName, TypeUtils.TUPLE2, parsingResult1, parsingResult2);
    }

    protected FunctionSignature.FunctionParamSignature parseTuple3(GlobalParsingContext context, AnnotationTree annotationTree, TypeName parentType, String methodName, String paramName) {
        AnnotationTree annotationTree1 = annotationTree.next();
        AnnotationTree annotationTree2 = annotationTree1.next();
        AnnotationTree annotationTree3 = annotationTree2.next();
        FunctionSignature.FunctionParamSignature parsingResult1 = this.parseParam(context, annotationTree1, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult2 = this.parseParam(context, annotationTree2, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult3 = this.parseParam(context, annotationTree3, parentType, methodName, paramName);
        return FunctionSignature.FunctionParamSignature.tupleType(paramName, TypeUtils.TUPLE3, parsingResult1, parsingResult2, parsingResult3);
    }

    protected FunctionSignature.FunctionParamSignature parseTuple4(GlobalParsingContext context, AnnotationTree annotationTree, TypeName parentType, String methodName, String paramName) {
        AnnotationTree annotationTree1 = annotationTree.next();
        AnnotationTree annotationTree2 = annotationTree1.next();
        AnnotationTree annotationTree3 = annotationTree2.next();
        AnnotationTree annotationTree4 = annotationTree3.next();
        FunctionSignature.FunctionParamSignature parsingResult1 = this.parseParam(context, annotationTree1, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult2 = this.parseParam(context, annotationTree2, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult3 = this.parseParam(context, annotationTree3, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult4 = this.parseParam(context, annotationTree4, parentType, methodName, paramName);
        return FunctionSignature.FunctionParamSignature.tupleType(paramName, TypeUtils.TUPLE4, parsingResult1, parsingResult2, parsingResult3, parsingResult4);
    }

    protected FunctionSignature.FunctionParamSignature parseTuple5(GlobalParsingContext context, AnnotationTree annotationTree, TypeName parentType, String methodName, String paramName) {
        AnnotationTree annotationTree1 = annotationTree.next();
        AnnotationTree annotationTree2 = annotationTree1.next();
        AnnotationTree annotationTree3 = annotationTree2.next();
        AnnotationTree annotationTree4 = annotationTree3.next();
        AnnotationTree annotationTree5 = annotationTree4.next();
        FunctionSignature.FunctionParamSignature parsingResult1 = this.parseParam(context, annotationTree1, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult2 = this.parseParam(context, annotationTree2, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult3 = this.parseParam(context, annotationTree3, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult4 = this.parseParam(context, annotationTree4, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult5 = this.parseParam(context, annotationTree5, parentType, methodName, paramName);
        return FunctionSignature.FunctionParamSignature.tupleType(paramName, TypeUtils.TUPLE5, parsingResult1, parsingResult2, parsingResult3, parsingResult4, parsingResult5);
    }

    protected FunctionSignature.FunctionParamSignature parseTuple6(GlobalParsingContext context, AnnotationTree annotationTree, TypeName parentType, String methodName, String paramName) {
        AnnotationTree annotationTree1 = annotationTree.next();
        AnnotationTree annotationTree2 = annotationTree1.next();
        AnnotationTree annotationTree3 = annotationTree2.next();
        AnnotationTree annotationTree4 = annotationTree3.next();
        AnnotationTree annotationTree5 = annotationTree4.next();
        AnnotationTree annotationTree6 = annotationTree5.next();
        FunctionSignature.FunctionParamSignature parsingResult1 = this.parseParam(context, annotationTree1, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult2 = this.parseParam(context, annotationTree2, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult3 = this.parseParam(context, annotationTree3, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult4 = this.parseParam(context, annotationTree4, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult5 = this.parseParam(context, annotationTree5, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult6 = this.parseParam(context, annotationTree6, parentType, methodName, paramName);
        return FunctionSignature.FunctionParamSignature.tupleType(paramName, TypeUtils.TUPLE6, parsingResult1, parsingResult2, parsingResult3, parsingResult4, parsingResult5, parsingResult6);
    }

    protected FunctionSignature.FunctionParamSignature parseTuple7(GlobalParsingContext context, AnnotationTree annotationTree, TypeName parentType, String methodName, String paramName) {
        AnnotationTree annotationTree1 = annotationTree.next();
        AnnotationTree annotationTree2 = annotationTree1.next();
        AnnotationTree annotationTree3 = annotationTree2.next();
        AnnotationTree annotationTree4 = annotationTree3.next();
        AnnotationTree annotationTree5 = annotationTree4.next();
        AnnotationTree annotationTree6 = annotationTree5.next();
        AnnotationTree annotationTree7 = annotationTree6.next();
        FunctionSignature.FunctionParamSignature parsingResult1 = this.parseParam(context, annotationTree1, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult2 = this.parseParam(context, annotationTree2, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult3 = this.parseParam(context, annotationTree3, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult4 = this.parseParam(context, annotationTree4, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult5 = this.parseParam(context, annotationTree5, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult6 = this.parseParam(context, annotationTree6, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult7 = this.parseParam(context, annotationTree7, parentType, methodName, paramName);
        return FunctionSignature.FunctionParamSignature.tupleType(paramName, TypeUtils.TUPLE7, parsingResult1, parsingResult2, parsingResult3, parsingResult4, parsingResult5, parsingResult6, parsingResult7);
    }

    protected FunctionSignature.FunctionParamSignature parseTuple8(GlobalParsingContext context, AnnotationTree annotationTree, TypeName parentType, String methodName, String paramName) {
        AnnotationTree annotationTree1 = annotationTree.next();
        AnnotationTree annotationTree2 = annotationTree1.next();
        AnnotationTree annotationTree3 = annotationTree2.next();
        AnnotationTree annotationTree4 = annotationTree3.next();
        AnnotationTree annotationTree5 = annotationTree4.next();
        AnnotationTree annotationTree6 = annotationTree5.next();
        AnnotationTree annotationTree7 = annotationTree6.next();
        AnnotationTree annotationTree8 = annotationTree7.next();
        FunctionSignature.FunctionParamSignature parsingResult1 = this.parseParam(context, annotationTree1, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult2 = this.parseParam(context, annotationTree2, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult3 = this.parseParam(context, annotationTree3, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult4 = this.parseParam(context, annotationTree4, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult5 = this.parseParam(context, annotationTree5, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult6 = this.parseParam(context, annotationTree6, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult7 = this.parseParam(context, annotationTree7, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult8 = this.parseParam(context, annotationTree8, parentType, methodName, paramName);
        return FunctionSignature.FunctionParamSignature.tupleType(paramName, TypeUtils.TUPLE8, parsingResult1, parsingResult2, parsingResult3, parsingResult4, parsingResult5, parsingResult6, parsingResult7, parsingResult8);
    }

    protected FunctionSignature.FunctionParamSignature parseTuple9(GlobalParsingContext context, AnnotationTree annotationTree, TypeName parentType, String methodName, String paramName) {
        AnnotationTree annotationTree1 = annotationTree.next();
        AnnotationTree annotationTree2 = annotationTree1.next();
        AnnotationTree annotationTree3 = annotationTree2.next();
        AnnotationTree annotationTree4 = annotationTree3.next();
        AnnotationTree annotationTree5 = annotationTree4.next();
        AnnotationTree annotationTree6 = annotationTree5.next();
        AnnotationTree annotationTree7 = annotationTree6.next();
        AnnotationTree annotationTree8 = annotationTree7.next();
        AnnotationTree annotationTree9 = annotationTree8.next();
        FunctionSignature.FunctionParamSignature parsingResult1 = this.parseParam(context, annotationTree1, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult2 = this.parseParam(context, annotationTree2, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult3 = this.parseParam(context, annotationTree3, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult4 = this.parseParam(context, annotationTree4, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult5 = this.parseParam(context, annotationTree5, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult6 = this.parseParam(context, annotationTree6, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult7 = this.parseParam(context, annotationTree7, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult8 = this.parseParam(context, annotationTree8, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult9 = this.parseParam(context, annotationTree9, parentType, methodName, paramName);
        return FunctionSignature.FunctionParamSignature.tupleType(paramName, TypeUtils.TUPLE9, parsingResult1, parsingResult2, parsingResult3, parsingResult4, parsingResult5, parsingResult6, parsingResult7, parsingResult8, parsingResult9);
    }

    protected FunctionSignature.FunctionParamSignature parseTuple10(GlobalParsingContext context, AnnotationTree annotationTree, TypeName parentType, String methodName, String paramName) {
        AnnotationTree annotationTree1 = annotationTree.next();
        AnnotationTree annotationTree2 = annotationTree1.next();
        AnnotationTree annotationTree3 = annotationTree2.next();
        AnnotationTree annotationTree4 = annotationTree3.next();
        AnnotationTree annotationTree5 = annotationTree4.next();
        AnnotationTree annotationTree6 = annotationTree5.next();
        AnnotationTree annotationTree7 = annotationTree6.next();
        AnnotationTree annotationTree8 = annotationTree7.next();
        AnnotationTree annotationTree9 = annotationTree8.next();
        AnnotationTree annotationTree10 = annotationTree9.next();
        FunctionSignature.FunctionParamSignature parsingResult1 = this.parseParam(context, annotationTree1, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult2 = this.parseParam(context, annotationTree2, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult3 = this.parseParam(context, annotationTree3, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult4 = this.parseParam(context, annotationTree4, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult5 = this.parseParam(context, annotationTree5, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult6 = this.parseParam(context, annotationTree6, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult7 = this.parseParam(context, annotationTree7, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult8 = this.parseParam(context, annotationTree8, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult9 = this.parseParam(context, annotationTree9, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult10 = this.parseParam(context, annotationTree10, parentType, methodName, paramName);
        return FunctionSignature.FunctionParamSignature.tupleType(paramName, TypeUtils.TUPLE10, parsingResult1, parsingResult2, parsingResult3, parsingResult4, parsingResult5, parsingResult6, parsingResult7, parsingResult8, parsingResult9, parsingResult10);
    }

    protected FunctionSignature.FunctionParamSignature parseList(GlobalParsingContext context, AnnotationTree annotationTree, TypeName parentType, String methodName, String paramName) {
        boolean isFrozen = AptUtils.containsAnnotation(annotationTree, Frozen.class);
        FunctionSignature.FunctionParamSignature parsingResult = this.parseParam(context, annotationTree.next(), parentType, methodName, paramName);
        return FunctionSignature.FunctionParamSignature.listType(paramName, parsingResult, isFrozen);
    }

    protected FunctionSignature.FunctionParamSignature parseSet(GlobalParsingContext context, AnnotationTree annotationTree, TypeName parentType, String methodName, String paramName) {
        boolean isFrozen = AptUtils.containsAnnotation(annotationTree, Frozen.class);
        FunctionSignature.FunctionParamSignature parsingResult = this.parseParam(context, annotationTree.next(), parentType, methodName, paramName);
        return FunctionSignature.FunctionParamSignature.setType(paramName, parsingResult, isFrozen);
    }

    protected FunctionSignature.FunctionParamSignature parseMap(GlobalParsingContext context, AnnotationTree annotationTree, TypeName parentType, String methodName, String paramName) {
        boolean isFrozen = AptUtils.containsAnnotation(annotationTree, Frozen.class);
        AnnotationTree annotationTree1 = annotationTree.next();
        AnnotationTree annotationTree2 = annotationTree1.next();
        FunctionSignature.FunctionParamSignature parsingResult1 = this.parseParam(context, annotationTree1, parentType, methodName, paramName);
        FunctionSignature.FunctionParamSignature parsingResult2 = this.parseParam(context, annotationTree2, parentType, methodName, paramName);
        return FunctionSignature.FunctionParamSignature.mapType(paramName, parsingResult1, parsingResult2, isFrozen);
    }

    protected FunctionSignature.FunctionParamSignature parseOptional(GlobalParsingContext context, AnnotationTree annotationTree, TypeName parentType, String methodName, String paramName) {
        FunctionSignature.FunctionParamSignature parsingResult = this.parseParam(context, annotationTree.next(), parentType, methodName, paramName);
        return FunctionSignature.FunctionParamSignature.optionalType(paramName, parsingResult);
    }

    protected FunctionSignature.FunctionParamSignature parseUDT(GlobalParsingContext context, AnnotationTree annotationTree, String paramName) {
        String udtName;
        boolean isFrozen = AptUtils.containsAnnotation(annotationTree, Frozen.class);
        TypeMirror typeMirror = annotationTree.getCurrentType();
        TypeName udtTypeName = TypeName.get((TypeMirror)typeMirror);
        TypeElement typeElement = AptUtils.asTypeElement(typeMirror);
        this.udtParser.validateUDT(context, udtTypeName, typeElement);
        Optional<Strategy> strategy = this.aptUtils.getAnnotationOnClass(typeElement, Strategy.class);
        UDT udt = this.aptUtils.getAnnotationOnClass(typeElement, UDT.class).get();
        String string = udtName = StringUtils.isBlank((CharSequence)udt.name()) ? InternalNamingStrategy.inferNamingStrategy(strategy, context.namingStrategy).apply(typeElement.getSimpleName().toString()) : udt.name();
        if (isFrozen) {
            return new FunctionSignature.FunctionParamSignature(paramName, udtTypeName, (TypeName)TypeUtils.JAVA_DRIVER_UDT_VALUE_TYPE, "frozen<" + udtName + ">");
        }
        return new FunctionSignature.FunctionParamSignature(paramName, udtTypeName, (TypeName)TypeUtils.JAVA_DRIVER_UDT_VALUE_TYPE, udtName);
    }

    private TypeName buildOrGetCodecFromRegistry(GlobalParsingContext context, AnnotationTree annotationTree, TypeName parentType, TypeName sourceType, String methodName, String paramName) {
        return this.codecFactory.determineTargetCQLType(context, annotationTree, parentType, sourceType, methodName, paramName, Optional.ofNullable(context.getCodecFor(sourceType)));
    }
}

