/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.parser;

import com.datastax.driver.core.ClusteringOrder;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import info.archinnov.achilles.annotations.ClusteringColumn;
import info.archinnov.achilles.annotations.Column;
import info.archinnov.achilles.annotations.Computed;
import info.archinnov.achilles.annotations.Counter;
import info.archinnov.achilles.annotations.DSE_Search;
import info.archinnov.achilles.annotations.Frozen;
import info.archinnov.achilles.annotations.Index;
import info.archinnov.achilles.annotations.JSON;
import info.archinnov.achilles.annotations.PartitionKey;
import info.archinnov.achilles.annotations.SASI;
import info.archinnov.achilles.annotations.Static;
import info.archinnov.achilles.exception.AchillesBeanMappingException;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.metamodel.columns.ClusteringColumnInfo;
import info.archinnov.achilles.internals.metamodel.columns.ColumnInfo;
import info.archinnov.achilles.internals.metamodel.columns.ColumnType;
import info.archinnov.achilles.internals.metamodel.columns.ComputedColumnInfo;
import info.archinnov.achilles.internals.metamodel.columns.PartitionKeyInfo;
import info.archinnov.achilles.internals.metamodel.index.IndexInfo;
import info.archinnov.achilles.internals.metamodel.index.IndexType;
import info.archinnov.achilles.internals.parser.AnnotationTree;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.context.AccessorsExclusionContext;
import info.archinnov.achilles.internals.parser.context.DSESearchInfoContext;
import info.archinnov.achilles.internals.parser.context.EntityParsingContext;
import info.archinnov.achilles.internals.parser.context.FieldInfoContext;
import info.archinnov.achilles.internals.parser.context.GlobalParsingContext;
import info.archinnov.achilles.internals.parser.context.IndexInfoContext;
import info.archinnov.achilles.internals.parser.context.SASIInfoContext;
import info.archinnov.achilles.type.TypedMap;
import info.archinnov.achilles.type.tuples.Tuple2;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.lang3.StringUtils;

public class FieldInfoParser {
    private final AptUtils aptUtils;

    public FieldInfoParser(AptUtils aptUtils) {
        this.aptUtils = aptUtils;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FieldInfoContext buildFieldInfo(VariableElement elm, AnnotationTree annotationTree, EntityParsingContext context) {
        CodeBlock setterLambda;
        CodeBlock getterLambda;
        TypeElement classElm = context.entityTypeElement;
        TypeName rawEntityClass = TypeName.get((TypeMirror)this.aptUtils.erasure(classElm));
        TypeName currentType = TypeName.get((TypeMirror)elm.asType()).box();
        String fieldName = elm.getSimpleName().toString();
        String cqlColumn = Optional.ofNullable(elm.getAnnotation(Column.class)).map(x -> x.value().isEmpty() ? null : x.value()).orElseGet(() -> context.namingStrategy.apply(fieldName));
        Optional<AccessorsExclusionContext> optionalAccessorExclusion = context.accessorsExclusionContexts.stream().filter(x -> x.fieldName.equals(fieldName)).findFirst();
        Tuple2<CodeBlock, ColumnType> columnTypeCode = this.buildColumnType(context.globalContext, elm, fieldName, rawEntityClass);
        Tuple2<CodeBlock, ColumnInfo> columnInfoCode = this.buildColumnInfo(context.globalContext, annotationTree, elm, fieldName, rawEntityClass);
        Optional<TypedMap> sasiAnnot = AptUtils.extractTypedMap(annotationTree, SASI.class);
        Optional<TypedMap> dseSearchAnnot = AptUtils.extractTypedMap(annotationTree, DSE_Search.class);
        Tuple2<CodeBlock, IndexInfo> indexInfoCode = sasiAnnot.isPresent() ? this.buildSASIIndexInfo(annotationTree, elm, context) : (dseSearchAnnot.isPresent() ? this.buildDSESearchIndexInfo(annotationTree) : this.buildNativeIndexInfo(annotationTree, elm, context));
        if (optionalAccessorExclusion.isPresent()) {
            AccessorsExclusionContext exclusionContext = optionalAccessorExclusion.get();
            if (exclusionContext.noGetter) {
                getterLambda = CodeBlock.builder().add("($T entity$$) -> entity$$.$L", new Object[]{rawEntityClass, fieldName}).build();
            } else {
                ExecutableElement getter = this.aptUtils.findGetter(classElm, elm, this.deriveGetterName(elm));
                getterLambda = CodeBlock.builder().add("($T entity$$) -> entity$$.$L()", new Object[]{rawEntityClass, getter.getSimpleName().toString()}).build();
            }
            if (!exclusionContext.noSetter) throw new AchillesBeanMappingException(String.format("AccessorsExclusionContext for entity '%s' but the setter is present", context.className));
            setterLambda = CodeBlock.builder().add("($T entity$$, $T value$$) -> {}", new Object[]{rawEntityClass, currentType}).build();
            return new FieldInfoContext(CodeBlock.builder().add("new $T<>($L, $L, $S, $S, $L, $L, $L)", new Object[]{TypeUtils.FIELD_INFO, getterLambda, setterLambda, fieldName, cqlColumn, columnTypeCode._1(), columnInfoCode._1(), indexInfoCode._1()}).build(), fieldName, cqlColumn, (ColumnType)((Object)columnTypeCode._2()), (ColumnInfo)columnInfoCode._2(), (IndexInfo)indexInfoCode._2());
        } else {
            ExecutableElement getter = this.aptUtils.findGetter(classElm, elm, this.deriveGetterName(elm));
            ExecutableElement setter = this.aptUtils.findSetter(classElm, elm, this.deriveSetterName(elm));
            getterLambda = CodeBlock.builder().add("($T entity$$) -> entity$$.$L()", new Object[]{rawEntityClass, getter.getSimpleName().toString()}).build();
            setterLambda = CodeBlock.builder().add("($T entity$$, $T value$$) -> entity$$.$L(value$$)", new Object[]{rawEntityClass, currentType, setter.getSimpleName().toString()}).build();
        }
        return new FieldInfoContext(CodeBlock.builder().add("new $T<>($L, $L, $S, $S, $L, $L, $L)", new Object[]{TypeUtils.FIELD_INFO, getterLambda, setterLambda, fieldName, cqlColumn, columnTypeCode._1(), columnInfoCode._1(), indexInfoCode._1()}).build(), fieldName, cqlColumn, (ColumnType)((Object)columnTypeCode._2()), (ColumnInfo)columnInfoCode._2(), (IndexInfo)indexInfoCode._2());
    }

    protected List<String> deriveGetterName(VariableElement elm) {
        String fieldName = elm.getSimpleName().toString();
        TypeMirror typeMirror = elm.asType();
        String camelCase = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        if (typeMirror.getKind() == TypeKind.BOOLEAN) {
            return Arrays.asList("is" + camelCase, "get" + camelCase);
        }
        return Arrays.asList("get" + camelCase);
    }

    protected String deriveSetterName(VariableElement elm) {
        String fieldName = elm.getSimpleName().toString();
        String setter = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        return setter;
    }

    protected Tuple2<CodeBlock, ColumnType> buildColumnType(GlobalParsingContext context, VariableElement elm, String fieldName, TypeName rawEntityClass) {
        CodeBlock.Builder builder = CodeBlock.builder();
        Optional<PartitionKey> partitionKey = Optional.ofNullable(elm.getAnnotation(PartitionKey.class));
        Optional<ClusteringColumn> clusteringColumn = Optional.ofNullable(elm.getAnnotation(ClusteringColumn.class));
        Optional<Static> staticColumn = Optional.ofNullable(elm.getAnnotation(Static.class));
        Optional<Computed> computed = Optional.ofNullable(elm.getAnnotation(Computed.class));
        Optional<Counter> counter = Optional.ofNullable(elm.getAnnotation(Counter.class));
        Optional<Index> index = Optional.ofNullable(elm.getAnnotation(Index.class));
        Optional<SASI> sasi = Optional.ofNullable(elm.getAnnotation(SASI.class));
        Optional<DSE_Search> dseSearch = Optional.ofNullable(elm.getAnnotation(DSE_Search.class));
        context.fieldValidator().validateCompatibleColumnAnnotationsOnField(this.aptUtils, fieldName, rawEntityClass, partitionKey, clusteringColumn, staticColumn, computed, counter);
        context.fieldValidator().validateCompatibleIndexAnnotationsOnField(context, this.aptUtils, fieldName, rawEntityClass, index, sasi, dseSearch);
        if (partitionKey.isPresent()) {
            builder.add("$T.$L", new Object[]{TypeUtils.COLUMN_TYPE, ColumnType.PARTITION.name()});
            return Tuple2.of((Object)builder.build(), (Object)((Object)ColumnType.PARTITION));
        }
        if (clusteringColumn.isPresent()) {
            builder.add("$T.$L", new Object[]{TypeUtils.COLUMN_TYPE, ColumnType.CLUSTERING.name()});
            return Tuple2.of((Object)builder.build(), (Object)((Object)ColumnType.CLUSTERING));
        }
        if (staticColumn.isPresent() && counter.isPresent()) {
            builder.add("$T.$L", new Object[]{TypeUtils.COLUMN_TYPE, ColumnType.STATIC_COUNTER.name()});
            return Tuple2.of((Object)builder.build(), (Object)((Object)ColumnType.STATIC_COUNTER));
        }
        if (staticColumn.isPresent()) {
            builder.add("$T.$L", new Object[]{TypeUtils.COLUMN_TYPE, ColumnType.STATIC.name()});
            return Tuple2.of((Object)builder.build(), (Object)((Object)ColumnType.STATIC));
        }
        if (computed.isPresent()) {
            builder.add("$T.$L", new Object[]{TypeUtils.COLUMN_TYPE, ColumnType.COMPUTED.name()});
            return Tuple2.of((Object)builder.build(), (Object)((Object)ColumnType.COMPUTED));
        }
        if (counter.isPresent()) {
            builder.add("$T.$L", new Object[]{TypeUtils.COLUMN_TYPE, ColumnType.COUNTER.name()});
            return Tuple2.of((Object)builder.build(), (Object)((Object)ColumnType.COUNTER));
        }
        builder.add("$T.$L", new Object[]{TypeUtils.COLUMN_TYPE, ColumnType.NORMAL.name()});
        return Tuple2.of((Object)builder.build(), (Object)((Object)ColumnType.NORMAL));
    }

    protected Tuple2<CodeBlock, ColumnInfo> buildColumnInfo(GlobalParsingContext context, AnnotationTree annotationTree, VariableElement elm, String fieldName, TypeName rawEntityClass) {
        CodeBlock.Builder builder = CodeBlock.builder();
        boolean isFrozen = AptUtils.containsAnnotation(annotationTree, Frozen.class);
        Optional<TypedMap> partitionKey = AptUtils.extractTypedMap(annotationTree, PartitionKey.class);
        Optional<TypedMap> clusteringColumn = AptUtils.extractTypedMap(annotationTree, ClusteringColumn.class);
        Optional<TypedMap> computed = AptUtils.extractTypedMap(annotationTree, Computed.class);
        context.fieldValidator().validateAllowedFrozen(isFrozen, this.aptUtils, elm, fieldName, rawEntityClass);
        if (partitionKey.isPresent()) {
            int order = (Integer)partitionKey.get().getTyped("order");
            this.aptUtils.validateTrue(order > 0, "@PartitionKey order on field '%s' of class '%s' should be > 0, the ordering starts at 1", fieldName, rawEntityClass);
            builder.add("new $T($L, $L)", new Object[]{TypeUtils.PARTITION_KEY_INFO, order, isFrozen});
            return Tuple2.of((Object)builder.build(), (Object)new PartitionKeyInfo(order, isFrozen));
        }
        if (clusteringColumn.isPresent()) {
            int order = (Integer)clusteringColumn.get().getTyped("order");
            ClusteringOrder clusteringOrder = (Boolean)clusteringColumn.get().getTyped("asc") != false ? ClusteringOrder.ASC : ClusteringOrder.DESC;
            this.aptUtils.validateTrue(order > 0, "@ClusteringColumn order on field '%s' of class '%s' should be > 0, the ordering starts at 1", fieldName, rawEntityClass);
            builder.add("new $T($L, $L, $T.$L)", new Object[]{TypeUtils.CLUSTERING_COLUMN_INFO, order, isFrozen, TypeUtils.CLUSTERING_ORDER, clusteringOrder.name()});
            return Tuple2.of((Object)builder.build(), (Object)new ClusteringColumnInfo(order, isFrozen, clusteringOrder));
        }
        if (computed.isPresent()) {
            TypedMap typedMap = computed.get();
            String function = (String)typedMap.getTyped("function");
            String alias = (String)typedMap.getTyped("alias");
            List targetColumns = (List)typedMap.getTyped("targetColumns");
            Class cqlClass = (Class)typedMap.getTyped("cqlClass");
            ClassName className = ClassName.get((Class)cqlClass);
            StringJoiner joiner = new StringJoiner(",");
            for (String x : targetColumns) {
                joiner.add("\"" + x + "\"");
            }
            builder.add("new $T($S, $S, $T.asList(new String[]{$L}), $T.class)", new Object[]{TypeUtils.COMPUTED_COLUMN_INFO, function, alias, TypeUtils.ARRAYS, joiner.toString(), className});
            return Tuple2.of((Object)builder.build(), (Object)new ComputedColumnInfo(function, alias, targetColumns, cqlClass));
        }
        builder.add("new $T($L)", new Object[]{TypeUtils.COLUMN_INFO, isFrozen});
        return Tuple2.of((Object)builder.build(), (Object)new ColumnInfo(isFrozen));
    }

    protected Tuple2<CodeBlock, IndexInfo> buildNativeIndexInfo(AnnotationTree annotationTree, VariableElement elm, EntityParsingContext context) {
        CodeBlock.Builder builder = CodeBlock.builder();
        TypeMirror currentType = this.aptUtils.erasure(annotationTree.getCurrentType());
        Optional<TypedMap> indexAnnot = AptUtils.extractTypedMap(annotationTree, Index.class);
        Name fieldName = elm.getSimpleName();
        Name className = AptUtils.enclosingClass(elm).getQualifiedName();
        boolean isFrozen = AptUtils.containsAnnotation(annotationTree, Frozen.class);
        boolean hasJSON = AptUtils.containsAnnotation(annotationTree, JSON.class);
        if (currentType.getKind().isPrimitive()) {
            if (indexAnnot.isPresent()) {
                IndexInfoContext indexInfoContext = this.getNativeIndexInfoContext(elm, context, indexAnnot);
                builder.add("$T.forNative($T.$L, $S, $S, $S)", new Object[]{TypeUtils.INDEX_INFO, TypeUtils.INDEX_TYPE, IndexType.NORMAL, indexInfoContext.indexName, indexInfoContext.indexClassName, indexInfoContext.indexOptions});
                IndexInfo indexInfo = IndexInfo.forNative(IndexType.NORMAL, indexInfoContext.indexName, indexInfoContext.indexClassName, indexInfoContext.indexOptions);
                return Tuple2.of((Object)builder.build(), (Object)indexInfo);
            }
            return Tuple2.of((Object)this.noIndex(), (Object)IndexInfo.noIndex());
        }
        if (this.aptUtils.isAssignableFrom(List.class, currentType) || this.aptUtils.isAssignableFrom(Set.class, currentType)) {
            AnnotationTree next;
            AnnotationTree annotationTree2 = next = hasJSON ? annotationTree : annotationTree.next();
            if (indexAnnot.isPresent()) {
                IndexInfoContext indexInfoContext = this.getNativeIndexInfoContext(elm, context, indexAnnot);
                IndexInfo indexInfo = this.buildIndexForListOrSet(builder, isFrozen, indexInfoContext);
                return Tuple2.of((Object)builder.build(), (Object)indexInfo);
            }
            if (AptUtils.containsAnnotation(next, Index.class)) {
                Optional<TypedMap> typedMap = AptUtils.extractTypedMap(next, Index.class);
                IndexInfoContext indexInfoContext = this.getNativeIndexInfoContext(elm, context, typedMap);
                IndexInfo indexInfo = this.buildIndexForListOrSet(builder, isFrozen, indexInfoContext);
                return Tuple2.of((Object)builder.build(), (Object)indexInfo);
            }
            return Tuple2.of((Object)this.noIndex(), (Object)IndexInfo.noIndex());
        }
        if (this.aptUtils.isAssignableFrom(Map.class, currentType)) {
            AnnotationTree valueAnnotationTree;
            AnnotationTree keyAnnotationTree = hasJSON ? annotationTree : annotationTree.next();
            AnnotationTree annotationTree3 = valueAnnotationTree = hasJSON ? annotationTree : annotationTree.next().next();
            if (indexAnnot.isPresent()) {
                IndexInfo indexInfo;
                IndexInfoContext indexInfoContext = this.getNativeIndexInfoContext(elm, context, indexAnnot);
                if (isFrozen) {
                    IndexType indexType = StringUtils.isBlank((CharSequence)indexInfoContext.indexClassName) ? IndexType.FULL : IndexType.CUSTOM;
                    builder.add("$T.forNative($T.$L, $S, $S, $S)", new Object[]{TypeUtils.INDEX_INFO, TypeUtils.INDEX_TYPE, indexType, indexInfoContext.indexName, indexInfoContext.indexClassName, indexInfoContext.indexOptions});
                    indexInfo = IndexInfo.forNative(indexType, indexInfoContext.indexName, indexInfoContext.indexClassName, indexInfoContext.indexOptions);
                } else {
                    IndexType indexType = StringUtils.isBlank((CharSequence)indexInfoContext.indexClassName) ? IndexType.MAP_ENTRY : IndexType.CUSTOM;
                    builder.add("$T.forNative($T.$L, $S, $S, $S)", new Object[]{TypeUtils.INDEX_INFO, TypeUtils.INDEX_TYPE, indexType, indexInfoContext.indexName, indexInfoContext.indexClassName, indexInfoContext.indexOptions});
                    indexInfo = IndexInfo.forNative(indexType, indexInfoContext.indexName, indexInfoContext.indexClassName, indexInfoContext.indexOptions);
                }
                this.aptUtils.validateFalse(AptUtils.containsAnnotation(keyAnnotationTree, Index.class), "Cannot have @Index on Map AND key type in field '%s' of class '%s'", fieldName, className);
                this.aptUtils.validateFalse(AptUtils.containsAnnotation(valueAnnotationTree, Index.class), "Cannot have @Index on Map AND value type in field '%s' of class '%s'", fieldName, className);
                return Tuple2.of((Object)builder.build(), (Object)indexInfo);
            }
            if (AptUtils.containsAnnotation(keyAnnotationTree, Index.class)) {
                this.aptUtils.validateFalse(AptUtils.containsAnnotation(valueAnnotationTree, Index.class), "Cannot have @Index on Map key AND value type in field '%s' of class '%s'", fieldName, className);
                IndexInfoContext keyIndexInfoContext = this.getNativeIndexInfoContext(elm, context, AptUtils.extractTypedMap(keyAnnotationTree, Index.class));
                IndexType indexType = StringUtils.isBlank((CharSequence)keyIndexInfoContext.indexClassName) ? IndexType.MAP_KEY : IndexType.CUSTOM;
                builder.add("$T.forNative($T.$L, $S, $S, $S)", new Object[]{TypeUtils.INDEX_INFO, TypeUtils.INDEX_TYPE, indexType, keyIndexInfoContext.indexName, keyIndexInfoContext.indexClassName, keyIndexInfoContext.indexOptions});
                IndexInfo indexInfo = IndexInfo.forNative(indexType, keyIndexInfoContext.indexName, keyIndexInfoContext.indexClassName, keyIndexInfoContext.indexOptions);
                return Tuple2.of((Object)builder.build(), (Object)indexInfo);
            }
            if (AptUtils.containsAnnotation(valueAnnotationTree, Index.class)) {
                this.aptUtils.validateFalse(AptUtils.containsAnnotation(keyAnnotationTree, Index.class), "Cannot have @Index on Map key AND value type in field '%s' of class '%s'", fieldName, className);
                IndexInfoContext valueIndexInfoContext = this.getNativeIndexInfoContext(elm, context, AptUtils.extractTypedMap(valueAnnotationTree, Index.class));
                IndexType indexType = StringUtils.isBlank((CharSequence)valueIndexInfoContext.indexClassName) ? IndexType.MAP_VALUE : IndexType.CUSTOM;
                builder.add("$T.forNative($T.$L, $S, $S, $S)", new Object[]{TypeUtils.INDEX_INFO, TypeUtils.INDEX_TYPE, indexType, valueIndexInfoContext.indexName, valueIndexInfoContext.indexClassName, valueIndexInfoContext.indexOptions});
                IndexInfo indexInfo = IndexInfo.forNative(indexType, valueIndexInfoContext.indexName, valueIndexInfoContext.indexClassName, valueIndexInfoContext.indexOptions);
                return Tuple2.of((Object)builder.build(), (Object)indexInfo);
            }
            return Tuple2.of((Object)this.noIndex(), (Object)IndexInfo.noIndex());
        }
        if (indexAnnot.isPresent()) {
            IndexInfoContext indexInfoContext = this.getNativeIndexInfoContext(elm, context, indexAnnot);
            IndexType indexType = StringUtils.isBlank((CharSequence)indexInfoContext.indexClassName) ? IndexType.NORMAL : IndexType.CUSTOM;
            builder.add("$T.forNative($T.$L, $S, $S, $S)", new Object[]{TypeUtils.INDEX_INFO, TypeUtils.INDEX_TYPE, indexType, indexInfoContext.indexName, indexInfoContext.indexClassName, indexInfoContext.indexOptions});
            IndexInfo indexInfo = IndexInfo.forNative(indexType, indexInfoContext.indexName, indexInfoContext.indexClassName, indexInfoContext.indexOptions);
            return Tuple2.of((Object)builder.build(), (Object)indexInfo);
        }
        return Tuple2.of((Object)this.noIndex(), (Object)IndexInfo.noIndex());
    }

    private IndexInfoContext getNativeIndexInfoContext(VariableElement elm, EntityParsingContext context, Optional<TypedMap> indexAnnot) {
        return ((IndexInfoContext)indexAnnot.get().getTyped("indexInfoContext")).build(elm, context);
    }

    protected Tuple2<CodeBlock, IndexInfo> buildDSESearchIndexInfo(AnnotationTree annotationTree) {
        CodeBlock.Builder builder = CodeBlock.builder();
        DSESearchInfoContext dseSearchInfoContext = (DSESearchInfoContext)AptUtils.extractTypedMap(annotationTree, DSE_Search.class).get().getTyped("dseSearchInfoContext");
        builder.add("$T.forDSESearch($L)", new Object[]{TypeUtils.INDEX_INFO, dseSearchInfoContext.fullTextSearchEnabled});
        return Tuple2.of((Object)builder.build(), (Object)IndexInfo.forDSESearch(dseSearchInfoContext.fullTextSearchEnabled));
    }

    protected Tuple2<CodeBlock, IndexInfo> buildSASIIndexInfo(AnnotationTree annotationTree, VariableElement elm, EntityParsingContext context) {
        CodeBlock.Builder builder = CodeBlock.builder();
        SASIInfoContext sasiInfoContext = ((SASIInfoContext)AptUtils.extractTypedMap(annotationTree, SASI.class).get().getTyped("sasiInfoContext")).build(elm, context);
        String indexName = sasiInfoContext.indexName;
        SASI.IndexMode indexMode = sasiInfoContext.indexMode;
        boolean analyzed = sasiInfoContext.analyzed;
        SASI.Analyzer analyzerClass = sasiInfoContext.analyzerClass;
        int maxCompactionFlushMemoryInMb = sasiInfoContext.maxCompactionFlushMemoryInMb;
        SASI.Normalization normalization = sasiInfoContext.normalization;
        String locale = sasiInfoContext.locale;
        boolean enableStemming = sasiInfoContext.enableStemming;
        boolean skipStopWords = sasiInfoContext.skipStopWords;
        builder.add("$T.forSASI($S, $T.$L, $L, $T.$L, $L, $T.$L, $S, $L, $L)", new Object[]{TypeUtils.INDEX_INFO, indexName, TypeUtils.SASI_INDEX_MODE, indexMode.name(), analyzed, TypeUtils.SASI_ANALYZER, analyzerClass.name(), maxCompactionFlushMemoryInMb, TypeUtils.SASI_NORMALIZATION, normalization.name(), locale, enableStemming, skipStopWords});
        IndexInfo indexInfo = IndexInfo.forSASI(indexName, indexMode, analyzed, analyzerClass, maxCompactionFlushMemoryInMb, normalization, locale, enableStemming, skipStopWords);
        return Tuple2.of((Object)builder.build(), (Object)indexInfo);
    }

    private IndexInfo buildIndexForListOrSet(CodeBlock.Builder builder, boolean isFrozen, IndexInfoContext indexInfo) {
        if (isFrozen) {
            IndexType indexType = StringUtils.isBlank((CharSequence)indexInfo.indexClassName) ? IndexType.FULL : IndexType.CUSTOM;
            builder.add("$T.forNative($T.$L, $S, $S, $S)", new Object[]{TypeUtils.INDEX_INFO, TypeUtils.INDEX_TYPE, indexType, indexInfo.indexName, indexInfo.indexClassName, indexInfo.indexOptions});
            return IndexInfo.forNative(indexType, indexInfo.indexName, indexInfo.indexClassName, indexInfo.indexOptions);
        }
        IndexType indexType = StringUtils.isBlank((CharSequence)indexInfo.indexClassName) ? IndexType.COLLECTION : IndexType.CUSTOM;
        builder.add("$T.forNative($T.$L, $S, $S, $S)", new Object[]{TypeUtils.INDEX_INFO, TypeUtils.INDEX_TYPE, indexType, indexInfo.indexName, indexInfo.indexClassName, indexInfo.indexOptions});
        return IndexInfo.forNative(indexType, indexInfo.indexName, indexInfo.indexClassName, indexInfo.indexOptions);
    }

    private CodeBlock noIndex() {
        return CodeBlock.builder().add("$T.noIndex()", new Object[]{TypeUtils.INDEX_INFO}).build();
    }
}

