/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.parser;

import com.google.auto.common.MoreElements;
import com.squareup.javapoet.TypeName;
import info.archinnov.achilles.annotations.CodecRegistry;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.parser.AbstractBeanParser;
import info.archinnov.achilles.internals.parser.AnnotationTree;
import info.archinnov.achilles.internals.parser.CodecFactory;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.context.FieldParsingContext;
import info.archinnov.achilles.internals.parser.context.GlobalParsingContext;
import info.archinnov.achilles.internals.strategy.field_filtering.FieldFilter;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class CodecRegistryParser
extends AbstractBeanParser {
    private final CodecFactory codecFactory;

    public CodecRegistryParser(AptUtils aptUtils) {
        super(aptUtils);
        this.codecFactory = new CodecFactory(aptUtils);
    }

    public void parseCodecs(RoundEnvironment roundEnv, GlobalParsingContext parsingContext) {
        HashMap map = new HashMap();
        roundEnv.getElementsAnnotatedWith(CodecRegistry.class).stream().map(MoreElements::asType).forEach(typeElm -> {
            String className = typeElm.getQualifiedName().toString();
            this.extractCandidateFields((TypeElement)typeElm, FieldFilter.CODEC_RELATED_ANNOTATIONS).forEach(varElm -> {
                TypeName typeName = TypeUtils.getRawType(TypeName.get((TypeMirror)varElm.asType()));
                AnnotationTree annotationTree = AnnotationTree.buildFrom(this.aptUtils, parsingContext, varElm);
                FieldParsingContext fieldParsingContext = FieldParsingContext.forConfig(parsingContext, typeElm, typeName, className, varElm.getSimpleName().toString());
                CodecFactory.CodecInfo codec = this.codecFactory.createCodec(typeName, annotationTree, fieldParsingContext, Optional.empty());
                if (map.containsKey(codec.sourceType)) {
                    this.aptUtils.printError("There is already a codec for source type %s in the class %s", codec.sourceType, className);
                } else {
                    map.put(codec.sourceType, codec);
                }
            });
        });
        parsingContext.codecRegistry.putAll(map);
    }
}

