/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.parser;

import com.google.auto.common.MoreTypes;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.WildcardTypeName;
import info.archinnov.achilles.annotations.Computed;
import info.archinnov.achilles.annotations.Counter;
import info.archinnov.achilles.annotations.Enumerated;
import info.archinnov.achilles.annotations.JSON;
import info.archinnov.achilles.annotations.RuntimeCodec;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.parser.AnnotationTree;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.context.CodecContext;
import info.archinnov.achilles.internals.parser.context.FieldParsingContext;
import info.archinnov.achilles.internals.parser.context.GlobalParsingContext;
import info.archinnov.achilles.internals.parser.context.RuntimeCodecContext;
import info.archinnov.achilles.internals.parser.validator.TypeValidator;
import info.archinnov.achilles.type.TypedMap;
import info.archinnov.achilles.type.codec.Codec;
import info.archinnov.achilles.type.tuples.Tuple2;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.lang3.ArrayUtils;

public class CodecFactory {
    private final AptUtils aptUtils;

    public CodecFactory(AptUtils aptUtils) {
        this.aptUtils = aptUtils;
    }

    public static CodecContext buildCodecContext(AptUtils aptUtils, AnnotationMirror codecFromType) {
        Optional codecClassO = AptUtils.getElementValueClass(codecFromType, "value", false);
        if (codecClassO.isPresent()) {
            Class codecClass = codecClassO.get();
            List<Type> genericTypes = Arrays.asList(codecClass.getGenericInterfaces());
            List codecTypes = genericTypes.stream().filter(x -> x instanceof ParameterizedType).map(x -> (ParameterizedType)x).filter(x -> x.getRawType().getTypeName().equals(Codec.class.getCanonicalName())).flatMap(x -> Arrays.asList(x.getActualTypeArguments()).stream()).map(TypeName::get).collect(Collectors.toList());
            aptUtils.validateTrue(codecTypes.size() == 2, "Codec class '%s' should have 2 parameters: Codec<FROM, TO>", codecClass);
            return new CodecContext((TypeName)ClassName.get(codecClass), (TypeName)codecTypes.get(0), (TypeName)codecTypes.get(1));
        }
        return CodecFactory.buildCodecContext(aptUtils, AptUtils.getElementValueClassName(codecFromType, "value", false).toString());
    }

    public static CodecContext buildCodecContext(AptUtils aptUtils, String codecClassName) {
        TypeMirror codecInterfaceType = aptUtils.erasure(aptUtils.elementUtils.getTypeElement(Codec.class.getCanonicalName()).asType());
        Optional<TypeMirror> foundCodecInterface = aptUtils.elementUtils.getTypeElement(codecClassName).getInterfaces().stream().filter(x -> aptUtils.typeUtils.isSameType(aptUtils.erasure((TypeMirror)x), codecInterfaceType)).findFirst();
        aptUtils.validateTrue(foundCodecInterface.isPresent(), "Codec class '%s' should implement the Codec<FROM, TO> interface", codecClassName);
        TypeMirror typeMirror = foundCodecInterface.get();
        List codecTypes = MoreTypes.asDeclared((TypeMirror)typeMirror).getTypeArguments().stream().map(TypeName::get).collect(Collectors.toList());
        aptUtils.validateTrue(codecTypes.size() == 2, "Codec class '%s' should have 2 parameters: Codec<FROM, TO>", codecInterfaceType);
        TypeMirror codecType = aptUtils.erasure(aptUtils.elementUtils.getTypeElement(codecClassName));
        return new CodecContext(TypeName.get((TypeMirror)codecType), (TypeName)codecTypes.get(0), (TypeName)codecTypes.get(1));
    }

    public static RuntimeCodecContext buildRuntimeCodecContext(TypeMirror currentType, AnnotationMirror annotation) {
        Class targetType = AptUtils.getElementValueClass(annotation, "cqlClass", false).get();
        Optional<String> codecName = Optional.ofNullable(AptUtils.getElementValue(annotation, "codecName", String.class, false));
        return new RuntimeCodecContext(TypeName.get((TypeMirror)currentType), TypeName.get(targetType), codecName);
    }

    public CodecInfo createCodec(TypeName sourceType, AnnotationTree annotationTree, FieldParsingContext context, Optional<CodecInfo> codecFromRegistry) {
        String fieldName = context.fieldName;
        String className = context.className;
        TypeName targetType = sourceType;
        TypeMirror typeMirror = annotationTree.getCurrentType();
        Optional<TypedMap> jsonTransform = AptUtils.extractTypedMap(annotationTree, JSON.class);
        Optional<TypedMap> enumerated = AptUtils.extractTypedMap(annotationTree, Enumerated.class);
        Optional<TypedMap> codecFromType = AptUtils.extractTypedMap(annotationTree, info.archinnov.achilles.annotations.Codec.class);
        Optional<TypedMap> runtimeCodec = AptUtils.extractTypedMap(annotationTree, RuntimeCodec.class);
        Optional<TypedMap> computed = AptUtils.extractTypedMap(annotationTree, Computed.class);
        Optional<TypeName> computedCQLClass = computed.map(x -> (Class)x.getTyped("cqlClass")).map(ClassName::get);
        boolean isCounter = AptUtils.extractTypedMap(annotationTree, Counter.class).isPresent();
        if (jsonTransform.isPresent()) {
            CodeBlock codec = CodeBlock.builder().add("new $T<>($T.class, $L)", new Object[]{TypeUtils.JSON_CODEC, TypeUtils.getRawType(sourceType).box(), this.buildJavaTypeForJackson(sourceType)}).build();
            targetType = ClassName.get(String.class);
            return new CodecInfo(codec, sourceType, targetType);
        }
        if (codecFromType.isPresent()) {
            Tuple2<TypeName, CodeBlock> tuple2 = this.codecCodeGen(context, codecFromType.get(), sourceType, computedCQLClass, isCounter);
            targetType = (TypeName)tuple2._1();
            CodeBlock codec = (CodeBlock)tuple2._2();
            return new CodecInfo(codec, sourceType, targetType);
        }
        if (runtimeCodec.isPresent()) {
            Tuple2<TypeName, CodeBlock> tuple2 = this.runtimeCodecCodeGen(context, runtimeCodec.get(), computedCQLClass, isCounter);
            targetType = (TypeName)tuple2._1();
            CodeBlock codec = (CodeBlock)tuple2._2();
            return new CodecInfo(codec, sourceType, targetType);
        }
        if (enumerated.isPresent()) {
            Tuple2<TypeName, CodeBlock> tuple2 = this.enumeratedCodecCodeGen(enumerated.get(), sourceType, fieldName, className);
            CodeBlock codec = (CodeBlock)tuple2._2();
            targetType = (TypeName)tuple2._1();
            return new CodecInfo(codec, sourceType, targetType);
        }
        if (typeMirror.getKind() == TypeKind.ARRAY && typeMirror.toString().equals("byte[]")) {
            if (codecFromRegistry.isPresent()) {
                return codecFromRegistry.get();
            }
            CodeBlock codec = CodeBlock.builder().add("new $T()", new Object[]{TypeUtils.BYTE_ARRAY_PRIMITIVE_CODEC}).build();
            return new CodecInfo(codec, sourceType, TypeUtils.BYTE_BUFFER);
        }
        if (typeMirror.getKind() == TypeKind.ARRAY && typeMirror.toString().equals("java.lang.Byte[]")) {
            if (codecFromRegistry.isPresent()) {
                return codecFromRegistry.get();
            }
            CodeBlock codec = CodeBlock.builder().add("new $T()", new Object[]{TypeUtils.BYTE_ARRAY_CODEC}).build();
            return new CodecInfo(codec, sourceType, TypeUtils.BYTE_BUFFER);
        }
        if (codecFromRegistry.isPresent()) {
            return codecFromRegistry.get();
        }
        if (computedCQLClass.isPresent()) {
            this.aptUtils.validateTrue(sourceType.equals((Object)computedCQLClass.get()), "CQL class '%s' of @Computed field '%s' of class '%s' should be same as field class '%s'", computedCQLClass.get(), fieldName, className, sourceType);
        }
        context.typeValidator().validateAllowedTypes(this.aptUtils, sourceType, sourceType);
        CodeBlock codec = CodeBlock.builder().add("new $T<>($T.class)", new Object[]{TypeUtils.FALL_THROUGH_CODEC, TypeUtils.getRawType(sourceType).box()}).build();
        return new CodecInfo(codec, sourceType, targetType);
    }

    public TypeName determineTargetCQLType(GlobalParsingContext context, AnnotationTree annotationTree, TypeName parentType, TypeName sourceType, String methodName, String paramName, Optional<CodecInfo> codecFromRegistry) {
        TypeValidator typeValidator = context.typeValidator();
        TypeName targetType = sourceType;
        TypeMirror typeMirror = annotationTree.getCurrentType();
        Optional<TypedMap> jsonTransform = AptUtils.extractTypedMap(annotationTree, JSON.class);
        Optional<TypedMap> enumerated = AptUtils.extractTypedMap(annotationTree, Enumerated.class);
        Optional<TypedMap> codecFromType = AptUtils.extractTypedMap(annotationTree, info.archinnov.achilles.annotations.Codec.class);
        Optional<TypedMap> runtimeCodec = AptUtils.extractTypedMap(annotationTree, RuntimeCodec.class);
        Optional<TypedMap> computed = AptUtils.extractTypedMap(annotationTree, Computed.class);
        Optional<TypeName> computedCQLClass = computed.map(x -> (Class)x.getTyped("cqlClass")).map(ClassName::get);
        boolean isCounter = AptUtils.extractTypedMap(annotationTree, Counter.class).isPresent();
        if (jsonTransform.isPresent()) {
            return ClassName.get(String.class);
        }
        if (codecFromType.isPresent()) {
            CodecContext codecContext = (CodecContext)codecFromType.get().getTyped("codecContext");
            context.fieldValidator().validateCodec(this.aptUtils, typeValidator, codecContext, sourceType, computedCQLClass, isCounter);
            return codecContext.targetType.box();
        }
        if (runtimeCodec.isPresent()) {
            RuntimeCodecContext runtimeCodecContext = (RuntimeCodecContext)runtimeCodec.get().getTyped("runtimeCodecContext");
            context.fieldValidator().validateCodec(this.aptUtils, typeValidator, runtimeCodecContext, runtimeCodecContext.sourceType, computedCQLClass, isCounter);
            return runtimeCodecContext.targetType.box();
        }
        if (enumerated.isPresent()) {
            TypedMap typedMap = enumerated.get();
            Object value = typedMap.getTyped("value");
            this.aptUtils.validateTrue(AptUtils.isAnEnum(value), "The type '%s' on param '%s' of method '%s' in class '%s' is not a java.lang.Enum type", sourceType.toString(), paramName, methodName, parentType);
            Enumerated.Encoding encoding = (Enumerated.Encoding)typedMap.getTyped("value");
            if (encoding == Enumerated.Encoding.NAME) {
                return TypeUtils.STRING;
            }
            return TypeUtils.OBJECT_INT;
        }
        if (typeMirror.getKind() == TypeKind.ARRAY && typeMirror.toString().equals("byte[]")) {
            if (codecFromRegistry.isPresent()) {
                return codecFromRegistry.get().targetType.box();
            }
            return TypeUtils.BYTE_BUFFER;
        }
        if (typeMirror.getKind() == TypeKind.ARRAY && typeMirror.toString().equals("java.lang.Byte[]")) {
            if (codecFromRegistry.isPresent()) {
                return codecFromRegistry.get().targetType.box();
            }
            return TypeUtils.BYTE_BUFFER;
        }
        if (codecFromRegistry.isPresent()) {
            return codecFromRegistry.get().targetType.box();
        }
        typeValidator.validateAllowedTypesForFunction(this.aptUtils, parentType.toString(), methodName, sourceType);
        return targetType;
    }

    private Tuple2<TypeName, CodeBlock> codecCodeGen(FieldParsingContext context, TypedMap annotationInfo, TypeName sourceType, Optional<TypeName> computedCQLClass, boolean isCounter) {
        CodecContext codecContext = (CodecContext)annotationInfo.getTyped("codecContext");
        context.fieldValidator().validateCodec(this.aptUtils, context.typeValidator(), codecContext, sourceType, computedCQLClass, isCounter);
        CodeBlock codec = CodeBlock.builder().add("new $T()", new Object[]{codecContext.codecType}).build();
        return new Tuple2((Object)codecContext.targetType.box(), (Object)codec);
    }

    private Tuple2<TypeName, CodeBlock> runtimeCodecCodeGen(FieldParsingContext context, TypedMap annotationInfo, Optional<TypeName> computedCQLClass, boolean isCounter) {
        RuntimeCodecContext runtimeCodecContext = (RuntimeCodecContext)annotationInfo.getTyped("runtimeCodecContext");
        TypeName sourceType = runtimeCodecContext.sourceType;
        TypeName targetType = runtimeCodecContext.targetType;
        context.fieldValidator().validateCodec(this.aptUtils, context.typeValidator(), runtimeCodecContext, sourceType, computedCQLClass, isCounter);
        CodeBlock codecNameCode = runtimeCodecContext.codecName.isPresent() ? CodeBlock.builder().add("$T.<$T>of($S)", new Object[]{TypeUtils.OPTIONAL, TypeUtils.STRING, runtimeCodecContext.codecName.get()}).build() : CodeBlock.builder().add("$T.<$T>empty()", new Object[]{TypeUtils.OPTIONAL, TypeUtils.STRING}).build();
        CodeBlock codec = CodeBlock.builder().add("new $T<$T,$T>($T.class, $T.class, $L)", new Object[]{TypeUtils.RUNTIME_CODEC_WRAPPER, sourceType, targetType, sourceType, targetType, codecNameCode}).build();
        return new Tuple2((Object)targetType.box(), (Object)codec);
    }

    private Tuple2<TypeName, CodeBlock> enumeratedCodecCodeGen(TypedMap annotationInfo, TypeName sourceType, String fieldName, String className) {
        Object value = annotationInfo.getTyped("value");
        this.aptUtils.validateTrue(AptUtils.isAnEnum(value), "The type '%s' on field '%s' in class '%s' is not a java.lang.Enum type", sourceType.toString(), fieldName, className);
        Enumerated.Encoding encoding = (Enumerated.Encoding)annotationInfo.getTyped("value");
        if (encoding == Enumerated.Encoding.NAME) {
            return new Tuple2((Object)TypeUtils.STRING, (Object)CodeBlock.builder().add("new $T<>(java.util.Arrays.asList($T.values()), $T.class)", new Object[]{TypeUtils.ENUM_NAME_CODEC, sourceType, sourceType.box()}).build());
        }
        return new Tuple2((Object)TypeUtils.OBJECT_INT, (Object)CodeBlock.builder().add("new $T<>(java.util.Arrays.asList($T.values()), $T.class)", new Object[]{TypeUtils.ENUM_ORDINAL_CODEC, sourceType, sourceType.box()}).build());
    }

    CodeBlock buildJavaTypeForJackson(TypeName sourceType) {
        if (sourceType instanceof ClassName) {
            ClassName className = (ClassName)sourceType;
            return CodeBlock.builder().add("$T.construct($T.class)", new Object[]{TypeUtils.SIMPLE_TYPE, className.box()}).build();
        }
        if (sourceType instanceof ParameterizedTypeName) {
            ParameterizedTypeName paramTypeName = (ParameterizedTypeName)sourceType;
            StringJoiner code = new StringJoiner(",", "$T.TYPE_FACTORY_INSTANCE.constructParametricType($T.class,", ")");
            for (TypeName x : paramTypeName.typeArguments) {
                code.add("$L");
            }
            Object[] headTypes = new Object[]{TypeUtils.JSON_CODEC, paramTypeName.rawType};
            Object[] codeBlocks = paramTypeName.typeArguments.stream().map(typeName -> this.buildJavaTypeForJackson((TypeName)typeName)).toArray();
            return CodeBlock.builder().add(code.toString(), ArrayUtils.addAll((Object[])headTypes, (Object[])codeBlocks)).build();
        }
        if (sourceType instanceof ArrayTypeName) {
            TypeName componentType = ((ArrayTypeName)sourceType).componentType;
            return CodeBlock.builder().add("$T.TYPE_FACTORY_INSTANCE.constructArrayType($L)", new Object[]{TypeUtils.JSON_CODEC, this.buildJavaTypeForJackson(componentType.box())}).build();
        }
        if (sourceType instanceof WildcardTypeName) {
            this.aptUtils.printError("Cannot build Jackson Mapper JavaType for wildcard type " + sourceType.toString(), new Object[0]);
        } else {
            this.aptUtils.printError("Cannot build Jackson Mapper JavaType for type " + sourceType.toString(), new Object[0]);
        }
        return null;
    }

    public static final class CodecInfo {
        protected final CodeBlock codecCode;
        protected final TypeName sourceType;
        protected final TypeName targetType;

        public CodecInfo(CodeBlock codecCode, TypeName sourceType, TypeName targetType) {
            this.codecCode = codecCode;
            this.sourceType = sourceType;
            this.targetType = targetType;
        }
    }
}

