/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.parser;

import com.squareup.javapoet.TypeName;
import info.archinnov.achilles.annotations.EntityCreator;
import info.archinnov.achilles.annotations.Strategy;
import info.archinnov.achilles.internals.apt.AptUtils;
import info.archinnov.achilles.internals.parser.FieldParser;
import info.archinnov.achilles.internals.parser.TypeUtils;
import info.archinnov.achilles.internals.parser.context.AccessorsExclusionContext;
import info.archinnov.achilles.internals.parser.context.ConstructorInfo;
import info.archinnov.achilles.internals.parser.context.EntityParsingContext;
import info.archinnov.achilles.internals.parser.context.GlobalParsingContext;
import info.archinnov.achilles.internals.parser.validator.BeanValidator;
import info.archinnov.achilles.internals.strategy.field_filtering.FieldFilter;
import info.archinnov.achilles.internals.strategy.naming.InternalNamingStrategy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractBeanParser {
    protected final AptUtils aptUtils;

    protected AbstractBeanParser(AptUtils aptUtils) {
        this.aptUtils = aptUtils;
    }

    public List<FieldParser.FieldMetaSignature> parseFields(TypeElement elm, FieldParser fieldParser, List<AccessorsExclusionContext> accessorsExclusionContexts, GlobalParsingContext context) {
        Optional<Strategy> strategy = this.aptUtils.getAnnotationOnClass(elm, Strategy.class);
        InternalNamingStrategy namingStrategy = InternalNamingStrategy.inferNamingStrategy(strategy, context.namingStrategy);
        EntityParsingContext entityContext = new EntityParsingContext(elm, TypeName.get((TypeMirror)this.aptUtils.erasure(elm)), namingStrategy, accessorsExclusionContexts, context);
        return this.extractCandidateFields(elm, context.fieldFilter).map(x -> fieldParser.parse((VariableElement)x, entityContext)).collect(Collectors.toList());
    }

    protected Stream<VariableElement> extractCandidateFields(TypeElement elm, FieldFilter fieldFilter) {
        return ElementFilter.fieldsIn(this.aptUtils.elementUtils.getAllMembers(elm)).stream().filter(fieldFilter);
    }

    /*
     * WARNING - void declaration
     */
    public List<FieldParser.FieldMetaSignature> parseAndValidateCustomConstructor(BeanValidator beanValidator, String entityClass, TypeElement elm, List<FieldParser.FieldMetaSignature> fieldMetaSignatures) {
        List fieldNames = fieldMetaSignatures.stream().map(x -> x.context.fieldName).collect(Collectors.toList());
        Map<String, FieldParser.FieldMetaSignature> fieldMetaByFieldName = fieldMetaSignatures.stream().collect(Collectors.toMap(x -> x.context.fieldName, x -> x));
        TypeName rawClassTypeName = TypeUtils.getRawType(TypeName.get((TypeMirror)elm.asType()));
        ConstructorInfo constructorInfo = beanValidator.validateConstructor(this.aptUtils, rawClassTypeName, elm);
        if (constructorInfo.type == ConstructorInfo.ConstructorType.IMMUTABLE) {
            List<? extends VariableElement> parameters = constructorInfo.constructor.getParameters();
            for (VariableElement variableElement : parameters) {
                String string = variableElement.getSimpleName().toString();
                TypeName paramBoxedType = TypeName.get((TypeMirror)variableElement.asType()).box();
                this.aptUtils.validateTrue(fieldNames.contains(string), "Cannot find matching field name for parameter '%s' of constructor on @Immutable entity '%s'", string, entityClass);
                TypeName boxedSourceType = fieldMetaByFieldName.get((Object)string).sourceType.box();
                this.aptUtils.validateTrue(boxedSourceType.equals((Object)paramBoxedType), "The type of parameter '%s' of constructor on @Immutable entity '%s' is wrong, it should be '%s'", string, entityClass, boxedSourceType.toString());
                VariableElement matchingField = ElementFilter.fieldsIn(this.aptUtils.elementUtils.getAllMembers(elm)).stream().filter(element -> element.getSimpleName().toString().equals(paramName)).findFirst().get();
                Set<Modifier> modifiers = matchingField.getModifiers();
                this.aptUtils.validateTrue(modifiers.contains((Object)Modifier.PUBLIC) && modifiers.contains((Object)Modifier.FINAL), "Field '%s' in entity '%s' should have 'public final' modifier because it is an @Immutable entity", string, entityClass);
            }
            return parameters.stream().map(param -> (FieldParser.FieldMetaSignature)fieldMetaByFieldName.get(param.getSimpleName().toString())).collect(Collectors.toList());
        }
        if (constructorInfo.type == ConstructorInfo.ConstructorType.ENTITY_CREATOR) {
            void var12_19;
            List<? extends VariableElement> parameters = constructorInfo.constructor.getParameters();
            EntityCreator annotation = constructorInfo.constructor.getAnnotation(EntityCreator.class);
            if (ArrayUtils.isEmpty((Object[])annotation.value())) {
                for (VariableElement variableElement : parameters) {
                    String paramName = variableElement.getSimpleName().toString();
                    TypeName paramBoxedType = TypeName.get((TypeMirror)variableElement.asType()).box();
                    this.aptUtils.validateTrue(fieldNames.contains(paramName), "Cannot find matching field name for parameter '%s' of @EntityCreator constructor on entity '%s'", paramName, entityClass);
                    TypeName sourceType = fieldMetaByFieldName.get((Object)paramName).sourceType.box();
                    this.aptUtils.validateTrue(sourceType.equals((Object)paramBoxedType), "The type of parameter '%s' of @EntityCreator constructor on entity '%s' is wrong, it should be '%s'", paramName, entityClass, sourceType.toString());
                }
                return parameters.stream().map(param -> (FieldParser.FieldMetaSignature)fieldMetaByFieldName.get(param.getSimpleName().toString())).collect(Collectors.toList());
            }
            List<String> list = Arrays.asList(annotation.value());
            this.aptUtils.validateTrue(list.size() == parameters.size(), "There should be '%s' declared field name in the @EntityCreator annotation for the entity '%s'", parameters.size(), entityClass);
            boolean bl = false;
            while (var12_19 < parameters.size()) {
                TypeName parameterBoxedType = TypeName.get((TypeMirror)parameters.get((int)var12_19).asType()).box();
                String matchingFieldName = list.get((int)var12_19);
                this.aptUtils.validateTrue(fieldNames.contains(matchingFieldName), "Cannot find matching field name for declared field '%s' on @EntityCreator annotation on entity '%s'", matchingFieldName, entityClass);
                TypeName sourceType = fieldMetaByFieldName.get((Object)matchingFieldName).sourceType.box();
                this.aptUtils.validateTrue(sourceType.equals((Object)parameterBoxedType), "The type of declared parameter '%s' on @EntityCreator annotation of entity '%s' is wrong, it should be '%s'", matchingFieldName, entityClass, sourceType.toString());
                ++var12_19;
            }
            return list.stream().map(fieldName -> (FieldParser.FieldMetaSignature)fieldMetaByFieldName.get(fieldName)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<AccessorsExclusionContext> prebuildAccessorsExclusion(TypeElement elm, GlobalParsingContext context) {
        TypeName rawClassTypeName = TypeUtils.getRawType(TypeName.get((TypeMirror)elm.asType()));
        ConstructorInfo constructorInfo = context.beanValidator().validateConstructor(this.aptUtils, rawClassTypeName, elm);
        if (constructorInfo.type == ConstructorInfo.ConstructorType.DEFAULT) {
            return Collections.emptyList();
        }
        if (constructorInfo.type == ConstructorInfo.ConstructorType.ENTITY_CREATOR) {
            List<? extends VariableElement> parameters = constructorInfo.constructor.getParameters();
            EntityCreator annotation = constructorInfo.constructor.getAnnotation(EntityCreator.class);
            if (ArrayUtils.isEmpty((Object[])annotation.value())) {
                return parameters.stream().map(param -> new AccessorsExclusionContext(param.getSimpleName().toString(), false, true)).collect(Collectors.toList());
            }
            return Arrays.asList(annotation.value()).stream().map(fieldName -> new AccessorsExclusionContext((String)fieldName, false, true)).collect(Collectors.toList());
        }
        List<? extends VariableElement> parameters = constructorInfo.constructor.getParameters();
        return parameters.stream().map(param -> new AccessorsExclusionContext(param.getSimpleName().toString(), true, true)).collect(Collectors.toList());
    }
}

