/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internals.options;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PagingState;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.RetryPolicy;
import info.archinnov.achilles.internals.context.ConfigurationContext;
import info.archinnov.achilles.internals.metamodel.AbstractEntityProperty;
import info.archinnov.achilles.internals.statements.OperationType;
import info.archinnov.achilles.internals.types.LimitedResultSetWrapper;
import info.archinnov.achilles.type.SchemaNameProvider;
import info.archinnov.achilles.validation.Validator;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraOptions {
    public static Integer MAX_RESULTS_DISPLAY_SIZE = 100;
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraOptions.class);
    private Optional<ConsistencyLevel> cl = Optional.empty();
    private Optional<ConsistencyLevel> serialCL = Optional.empty();
    private Optional<Long> defaultTimestamp = Optional.empty();
    private Optional<Integer> timeToLive = Optional.empty();
    private Optional<Integer> fetchSize = Optional.empty();
    private Optional<Boolean> idempotent = Optional.empty();
    private Optional<Map<String, ByteBuffer>> outgoingPayLoad = Optional.empty();
    private Optional<PagingState> pagingState = Optional.empty();
    private Optional<RetryPolicy> retryPolicy = Optional.empty();
    private Optional<List<Function<ResultSet, ResultSet>>> resultSetAsyncListeners = Optional.empty();
    private Optional<List<Function<Row, Row>>> rowAsyncListeners = Optional.empty();
    private Optional<Boolean> tracing = Optional.empty();
    private Optional<SchemaNameProvider> schemaNameProvider = Optional.empty();
    private Optional<Integer> readTimeout = Optional.empty();
    private Optional<StringJoiner> dseSearchSolrQuery = Optional.empty();
    private Optional<String> dseSearchRawSolrQuery = Optional.empty();
    private Optional<Integer> DMLResultsDisplaySize = Optional.empty();

    public static CassandraOptions withSchemaNameProvider(SchemaNameProvider schemaNameProvider) {
        CassandraOptions cassandraOptions = new CassandraOptions();
        Validator.validateNotNull((Object)schemaNameProvider, (String)"The provided schemaNameProvider should not be null", (Object[])new Object[0]);
        cassandraOptions.setSchemaNameProvider(Optional.of(schemaNameProvider));
        return cassandraOptions;
    }

    public int computeMaxDisplayedResults(ConfigurationContext configContext) {
        return this.DMLResultsDisplaySize.orElse(configContext.getDMLResultsDisplaySize());
    }

    public void appendToSolrQuery(String solrQuery) {
        if (!this.dseSearchSolrQuery.isPresent()) {
            this.dseSearchSolrQuery = Optional.of(new StringJoiner(" AND "));
        }
        this.dseSearchSolrQuery = this.dseSearchSolrQuery.map(content -> content.add(solrQuery));
        this.dseSearchRawSolrQuery = Optional.empty();
    }

    public void rawSolrQuery(String rawSolrQuery) {
        this.dseSearchRawSolrQuery = Optional.of(rawSolrQuery);
        this.dseSearchSolrQuery = Optional.empty();
    }

    public boolean hasSolrQuery() {
        return this.dseSearchSolrQuery.isPresent() || this.dseSearchRawSolrQuery.isPresent();
    }

    public boolean hasRawSolrQuery() {
        return this.dseSearchRawSolrQuery.isPresent();
    }

    public String generateSolrQuery() {
        return this.dseSearchSolrQuery.get().toString();
    }

    public String generateRawSolrQuery() {
        return this.dseSearchRawSolrQuery.get();
    }

    public boolean hasCl() {
        return this.cl.isPresent();
    }

    public Optional<ConsistencyLevel> getCl() {
        return this.cl;
    }

    public void setCl(Optional<ConsistencyLevel> cl) {
        this.cl = cl;
    }

    public boolean hasSerialCl() {
        return this.serialCL.isPresent();
    }

    public Optional<ConsistencyLevel> getSerialCL() {
        return this.serialCL;
    }

    public void setSerialCL(Optional<ConsistencyLevel> serialCL) {
        this.serialCL = serialCL;
    }

    public boolean hasDefaultTimestamp() {
        return this.defaultTimestamp.isPresent();
    }

    public Optional<Long> getDefaultTimestamp() {
        return this.defaultTimestamp;
    }

    public void setDefaultTimestamp(Optional<Long> defaultTimestamp) {
        this.defaultTimestamp = defaultTimestamp;
    }

    public boolean hasFetchSize() {
        return this.fetchSize.isPresent();
    }

    public Optional<Integer> getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(Optional<Integer> fetchSize) {
        this.fetchSize = fetchSize;
    }

    public boolean hasIdempotent() {
        return this.idempotent.isPresent();
    }

    public Optional<Boolean> getIdempotent() {
        return this.idempotent;
    }

    public void setIdempotent(Optional<Boolean> idempotent) {
        this.idempotent = idempotent;
    }

    public boolean hasOutgoingPayload() {
        return this.outgoingPayLoad.isPresent();
    }

    public Optional<Map<String, ByteBuffer>> getOutgoingPayLoad() {
        return this.outgoingPayLoad;
    }

    public void setOutgoingPayLoad(Optional<Map<String, ByteBuffer>> outgoingPayLoad) {
        this.outgoingPayLoad = outgoingPayLoad;
    }

    public boolean hasPagingState() {
        return this.pagingState.isPresent();
    }

    public Optional<PagingState> getPagingState() {
        return this.pagingState;
    }

    public void setPagingState(Optional<PagingState> pagingState) {
        this.pagingState = pagingState;
    }

    public boolean hasRetryPolicy() {
        return this.retryPolicy.isPresent();
    }

    public Optional<RetryPolicy> getRetryPolicy() {
        return this.retryPolicy;
    }

    public void setRetryPolicy(Optional<RetryPolicy> retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public ResultSet resultSetAsyncListener(ResultSet originalResultSet) {
        LimitedResultSetWrapper limitedRs = new LimitedResultSetWrapper(originalResultSet);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Applying Async listeners %s to the resultset %s", this.resultSetAsyncListeners, limitedRs));
        }
        this.resultSetAsyncListeners.ifPresent(list -> list.forEach(x -> {
            ResultSet cfr_ignored_0 = (ResultSet)x.apply(limitedRs);
        }));
        return originalResultSet;
    }

    public Row rowAsyncListener(Row row) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Applying Async listeners %s to row %s", this.rowAsyncListeners, row));
        }
        this.rowAsyncListeners.map(list -> list.stream().map(listener -> (Row)listener.apply(row)).count()).orElse(0L);
        return row;
    }

    public Optional<List<Function<ResultSet, ResultSet>>> getResultSetAsyncListeners() {
        return this.resultSetAsyncListeners;
    }

    public void setResultSetAsyncListeners(Optional<List<Function<ResultSet, ResultSet>>> resultSetAsyncListeners) {
        this.resultSetAsyncListeners = resultSetAsyncListeners;
    }

    public Optional<List<Function<Row, Row>>> getRowAsyncListeners() {
        return this.rowAsyncListeners;
    }

    public void setRowAsyncListeners(Optional<List<Function<Row, Row>>> rowAsyncListeners) {
        this.rowAsyncListeners = rowAsyncListeners;
    }

    public Optional<Boolean> getTracing() {
        return this.tracing;
    }

    public void setTracing(Optional<Boolean> tracing) {
        this.tracing = tracing;
    }

    public boolean hasTTL() {
        return this.timeToLive.isPresent();
    }

    public Optional<Integer> getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(Optional<Integer> timeToLive) {
        this.timeToLive = timeToLive;
    }

    public boolean hasSchemaNameProvider() {
        return this.schemaNameProvider.isPresent();
    }

    public Optional<SchemaNameProvider> getSchemaNameProvider() {
        return this.schemaNameProvider;
    }

    public void setSchemaNameProvider(Optional<SchemaNameProvider> schemaNameProvider) {
        this.schemaNameProvider = schemaNameProvider;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = Optional.ofNullable(readTimeout);
    }

    public void setDMLResultsDisplaySize(Optional<Integer> DMLResultsDisplaySize) {
        this.DMLResultsDisplaySize = DMLResultsDisplaySize;
    }

    public Statement applyOptions(OperationType operationType, AbstractEntityProperty<?> meta, Statement statement) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Applying options %s to the current statement %s", this.toString(), statement.toString()));
        }
        if (meta.isTable()) {
            statement.setConsistencyLevel(operationType.isUpsert ? meta.writeConsistency(this.cl) : meta.readConsistency(this.cl));
            statement.setSerialConsistencyLevel(meta.serialConsistency(this.serialCL));
        } else if (meta.isView()) {
            statement.setConsistencyLevel(meta.readConsistency(this.cl));
        }
        if (this.defaultTimestamp.isPresent() && operationType.isUpsert && meta.isTable()) {
            statement.setDefaultTimestamp(this.defaultTimestamp.get().longValue());
        }
        if (this.fetchSize.isPresent()) {
            statement.setFetchSize(this.fetchSize.get().intValue());
        }
        if (this.idempotent.isPresent()) {
            statement.setIdempotent(this.idempotent.get().booleanValue());
        }
        if (this.outgoingPayLoad.isPresent()) {
            statement.setOutgoingPayload(this.outgoingPayLoad.get());
        }
        if (this.pagingState.isPresent()) {
            statement.setPagingState(this.pagingState.get());
        }
        if (this.retryPolicy.isPresent()) {
            statement.setRetryPolicy(this.retryPolicy.get());
        }
        if (this.tracing.isPresent() || meta.entityLogger.isTraceEnabled()) {
            statement.enableTracing();
        }
        if (this.readTimeout.isPresent()) {
            statement.setReadTimeoutMillis(this.readTimeout.get().intValue());
        }
        return statement;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Options{");
        sb.append("cl=").append(this.cl);
        sb.append(", serialCL=").append(this.serialCL);
        sb.append(", defaultTimestamp=").append(this.defaultTimestamp);
        sb.append(", timeToLive=").append(this.timeToLive);
        sb.append(", fetchSize=").append(this.fetchSize);
        sb.append(", idempotent=").append(this.idempotent);
        sb.append(", outgoingPayLoad=").append(this.outgoingPayLoad);
        sb.append(", pagingState=").append(this.pagingState);
        sb.append(", retryPolicy=").append(this.retryPolicy);
        sb.append(", resultSetAsyncListeners=").append(this.resultSetAsyncListeners);
        sb.append(", rowAsyncListeners=").append(this.rowAsyncListeners);
        sb.append(", tracing=").append(this.tracing);
        sb.append(", schemaNameProvider=").append(this.schemaNameProvider);
        sb.append(", readTimeoutInMillis=").append(this.readTimeout);
        sb.append(", DMLResultsDisplaySize=").append(this.DMLResultsDisplaySize);
        sb.append('}');
        return sb.toString();
    }
}

